/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ConsoleInputStream
extends InputStream {
    private final ArrayList<byte[]> buffer = new ArrayList();
    private byte[] current;
    private int pos;
    private boolean isClosed;

    public synchronized int read() {
        while (this.current == null && this.buffer.isEmpty() && !this.isClosed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
        }
        if (this.isClosed) {
            return -1;
        }
        try {
            if (this.current == null) {
                this.current = this.buffer.remove(0);
                int n = this.current[this.pos++] & 0xFF;
                return n;
            }
            int n = this.current[this.pos++] & 0xFF;
            return n;
        }
        finally {
            if (this.current != null && this.pos == this.current.length) {
                this.current = null;
                this.pos = 0;
            }
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return len;
        }
        int i = this.read();
        if (i == -1) {
            return -1;
        }
        b[off] = (byte)i;
        return 1;
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.notifyAll();
    }

    public synchronized void add(byte[] data) {
        if (data.length > 0) {
            this.buffer.add(data);
            this.notify();
        }
    }
}

