/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.common;

import org.eclipse.equinox.jmx.internal.common.CommonMessages;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String DEFAULT_DOMAIN = "jmxserver";
    public static final String DEFAULT_PORT = "3600";
    public static final int DEFAULT_PORT_AS_INT = 3600;
    public static final String DEFAULT_HOST_PORT = "127.0.0.1:3600";
    public static final String PLUGIN_ID = "org.eclipse.equinox.jmx.common";
    public static final String PT_CONTRIBUTIONUI = "contributionui";
    private static Activator instance;
    private static BundleContext bundleContext;
    private static ServiceTracker logService;
    static /* synthetic */ Class class$0;

    public Activator() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        if (logService != null) {
            logService.close();
            logService = null;
        }
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    public static Activator getDefault() {
        return instance;
    }

    public static void log(String message, Throwable exception, int iStatusSeverity) {
        if (message == null && (message = exception.getMessage()) == null) {
            message = CommonMessages.exception_occurred;
        }
        if (logService == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logService = new ServiceTracker(bundleContext, clazz.getName(), null);
            logService.open();
        }
        LogService log = (LogService)logService.getService();
        int severity = 3;
        switch (iStatusSeverity) {
            case 4: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            default: {
                severity = 3;
            }
        }
        if (log == null) {
            System.out.println(PLUGIN_ID);
            System.out.println(severity);
            System.out.println(message);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        } else {
            log.log(severity, message, exception);
        }
    }

    public static void logError(String message, Throwable exception) {
        Activator.log(message, exception, 4);
    }

    public static void logError(Throwable exception) {
        Activator.log(exception.getMessage(), exception, 4);
    }

    public static void log(String message) {
        Activator.log(message, null, 1);
    }

    public static void log(Throwable exception) {
        Activator.log(exception.getMessage(), exception, 1);
    }
}

