/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public abstract class AbstractMarshallerImpl
implements Marshaller {
    private String encoding = "UTF-8";
    private String schemaLocation;
    private String noNSSchemaLocation;
    private boolean isFormattedOutput = true;
    private ValidationEventHandler eventHandler = DefaultValidationEventHandler.theInstance;

    public void setEventHandler(ValidationEventHandler pHandler) throws JAXBException {
        this.eventHandler = pHandler;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.eventHandler;
    }

    public void setProperty(String pName, Object pValue) throws PropertyException {
        if (pName == null) {
            throw new IllegalArgumentException("The property name must not be null.");
        }
        if ("jaxb.encoding".equals(pName)) {
            this.setEncoding((String)pValue);
        } else if ("jaxb.formatted.output".equals(pName)) {
            if (pValue == null) {
                this.setFormattedOutput(true);
            } else {
                this.setFormattedOutput((Boolean)pValue);
            }
        } else if ("jaxb.schemaLocation".equals(pName)) {
            this.setSchemaLocation((String)pValue);
        } else if ("jaxb.noNamespaceSchemaLocation".equals(pName)) {
            this.setNoNSSchemaLocation((String)pValue);
        } else {
            throw new PropertyException("Unknown property name: " + pName);
        }
    }

    public Object getProperty(String pName) throws PropertyException {
        if (pName == null) {
            throw new IllegalArgumentException("The property name must not be null.");
        }
        if ("jaxb.encoding".equals(pName)) {
            return this.getEncoding();
        }
        if ("jaxb.formatted.output".equals(pName)) {
            return this.isFormattedOutput() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("jaxb.schemaLocation".equals(pName)) {
            return this.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(pName)) {
            return this.getNoNSSchemaLocation();
        }
        throw new PropertyException("Unknown property name: " + pName);
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected String getJavaEncoding(String pEncoding) throws UnsupportedEncodingException {
        "".getBytes(pEncoding);
        return pEncoding;
    }

    protected void setEncoding(String pEncoding) {
        this.encoding = pEncoding == null ? "UTF-8" : pEncoding;
    }

    protected void setSchemaLocation(String pSchemaLocation) {
        this.schemaLocation = pSchemaLocation;
    }

    protected String getSchemaLocation() {
        return this.schemaLocation;
    }

    protected void setNoNSSchemaLocation(String pNoNSSchemaLocation) {
        this.noNSSchemaLocation = pNoNSSchemaLocation;
    }

    protected String getNoNSSchemaLocation() {
        return this.noNSSchemaLocation;
    }

    protected void setFormattedOutput(boolean pFormattedOutput) {
        this.isFormattedOutput = pFormattedOutput;
    }

    protected boolean isFormattedOutput() {
        return this.isFormattedOutput;
    }

    public final void marshal(Object pObject, OutputStream pStream) throws JAXBException {
        StreamResult sr = new StreamResult();
        sr.setOutputStream(pStream);
        this.marshal(pObject, sr);
    }

    public final void marshal(Object pObject, Writer pWriter) throws JAXBException {
        StreamResult sr = new StreamResult();
        sr.setWriter(pWriter);
        this.marshal(pObject, sr);
    }

    public final void marshal(Object pObject, ContentHandler pHandler) throws JAXBException {
        SAXResult sr = new SAXResult();
        sr.setHandler(pHandler);
        this.marshal(pObject, sr);
    }

    public final void marshal(Object pObject, Node pNode) throws JAXBException {
        DOMResult dr = new DOMResult();
        dr.setNode(pNode);
        this.marshal(pObject, dr);
    }

    public Node getNode(Object obj) throws JAXBException {
        throw new UnsupportedOperationException("This operation is unsupported.");
    }
}

