/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    private static final long serialVersionUID = 1L;
    public final java.util.Calendar calendar;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int YEAR_WOY = 17;
    public static final int DOW_LOCAL = 18;
    public static final int EXTENDED_YEAR = 19;
    public static final int JULIAN_DAY = 20;
    public static final int MILLISECONDS_IN_DAY = 21;
    public static final int IS_LEAP_MONTH = 22;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int WEEKDAY = 0;
    public static final int WEEKEND = 1;
    public static final int WEEKEND_ONSET = 2;
    public static final int WEEKEND_CEASE = 3;
    private static volatile ULocale[] availableLocales;
    private static final int FIELD_COUNT = 23;

    public Calendar(java.util.Calendar delegate) {
        this.calendar = delegate;
    }

    protected Calendar() {
        this(TimeZone.getDefault(), ULocale.getDefault());
    }

    protected Calendar(TimeZone zone, Locale aLocale) {
        this(zone, ULocale.forLocale(aLocale));
    }

    protected Calendar(TimeZone zone, ULocale locale) {
        this.calendar = java.util.Calendar.getInstance(zone.timeZone, locale.toLocale());
    }

    public static synchronized Calendar getInstance() {
        return new Calendar(java.util.Calendar.getInstance());
    }

    public static synchronized Calendar getInstance(TimeZone zone) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone));
    }

    public static synchronized Calendar getInstance(Locale aLocale) {
        return new Calendar(java.util.Calendar.getInstance(aLocale));
    }

    public static synchronized Calendar getInstance(ULocale locale) {
        return new Calendar(java.util.Calendar.getInstance(locale.toLocale()));
    }

    public static synchronized Calendar getInstance(TimeZone zone, Locale aLocale) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone, aLocale));
    }

    public static synchronized Calendar getInstance(TimeZone zone, ULocale locale) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone, locale.toLocale()));
    }

    public static Locale[] getAvailableLocales() {
        return java.util.Calendar.getAvailableLocales();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ULocale[] getAvailableULocales() {
        if (availableLocales != null) return (ULocale[])availableLocales.clone();
        Class<Calendar> clazz = Calendar.class;
        synchronized (Calendar.class) {
            if (availableLocales != null) return (ULocale[])availableLocales.clone();
            Locale[] locales = Locale.getAvailableLocales();
            availableLocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                Calendar.availableLocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (ULocale[])availableLocales.clone();
        }
    }

    public static final String[] getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public final Date getTime() {
        return this.calendar.getTime();
    }

    public final void setTime(Date date) {
        this.calendar.setTime(date);
    }

    public long getTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public void setTimeInMillis(long millis) {
        this.calendar.setTimeInMillis(millis);
    }

    public final int get(int field) {
        return this.calendar.get(Calendar.getJDKField(field));
    }

    public final void set(int field, int value) {
        this.calendar.set(Calendar.getJDKField(field), value);
    }

    public final void set(int year, int month, int date) {
        this.calendar.set(Calendar.getJDKField(1), year);
        this.calendar.set(Calendar.getJDKField(2), month);
        this.calendar.set(Calendar.getJDKField(5), date);
    }

    public final void set(int year, int month, int date, int hour, int minute) {
        this.calendar.set(Calendar.getJDKField(1), year);
        this.calendar.set(Calendar.getJDKField(2), month);
        this.calendar.set(Calendar.getJDKField(5), date);
        this.calendar.set(Calendar.getJDKField(11), hour);
        this.calendar.set(Calendar.getJDKField(12), minute);
    }

    public final void set(int year, int month, int date, int hour, int minute, int second) {
        this.calendar.set(Calendar.getJDKField(1), year);
        this.calendar.set(Calendar.getJDKField(2), month);
        this.calendar.set(Calendar.getJDKField(5), date);
        this.calendar.set(Calendar.getJDKField(11), hour);
        this.calendar.set(Calendar.getJDKField(12), minute);
        this.calendar.set(Calendar.getJDKField(13), second);
    }

    public final void clear() {
        this.calendar.clear();
    }

    public final void clear(int field) {
        this.calendar.clear(Calendar.getJDKField(field));
    }

    public final boolean isSet(int field) {
        return this.calendar.isSet(Calendar.getJDKField(field));
    }

    public boolean equals(Object obj) {
        try {
            return this.calendar.equals(((Calendar)obj).calendar);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEquivalentTo(Calendar other) {
        return this.calendar.getClass() == other.calendar.getClass() && this.calendar.isLenient() == other.calendar.isLenient() && this.calendar.getFirstDayOfWeek() == other.calendar.getFirstDayOfWeek() && this.calendar.getMinimalDaysInFirstWeek() == other.calendar.getMinimalDaysInFirstWeek() && this.calendar.getTimeZone().equals(other.calendar.getTimeZone());
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }

    private long compare(Object that) {
        long thatMs;
        if (that instanceof Calendar) {
            thatMs = ((Calendar)that).getTimeInMillis();
        } else if (that instanceof Date) {
            thatMs = ((Date)that).getTime();
        } else {
            throw new IllegalArgumentException(that + "is not a Calendar or Date");
        }
        return this.getTimeInMillis() - thatMs;
    }

    public boolean before(Object when) {
        return this.compare(when) < 0L;
    }

    public boolean after(Object when) {
        return this.compare(when) > 0L;
    }

    public int getActualMaximum(int field) {
        return this.calendar.getActualMaximum(Calendar.getJDKField(field));
    }

    public int getActualMinimum(int field) {
        return this.calendar.getActualMinimum(Calendar.getJDKField(field));
    }

    public final void roll(int field, boolean up) {
        this.calendar.roll(Calendar.getJDKField(field), up);
    }

    public void roll(int field, int amount) {
        this.calendar.roll(Calendar.getJDKField(field), amount);
    }

    public void add(int field, int amount) {
        this.calendar.add(Calendar.getJDKField(field), amount);
    }

    private static String _getDisplayName(Calendar cal) {
        String type = cal.getType();
        if (type.equals("japanese")) {
            return "Japanese Calendar";
        }
        if (type.equals("buddhist")) {
            return "Buddhist Calendar";
        }
        return "Gregorian Calendar";
    }

    public String getDisplayName(Locale loc) {
        return Calendar._getDisplayName(this);
    }

    public String getDisplayName(ULocale loc) {
        return Calendar._getDisplayName(this);
    }

    @Override
    public int compareTo(Calendar that) {
        return this.calendar.compareTo(that.calendar);
    }

    public DateFormat getDateTimeFormat(int dateStyle, int timeStyle, Locale loc) {
        if (dateStyle != -1) {
            if (timeStyle == -1) {
                return DateFormat.getDateInstance((Calendar)this.clone(), dateStyle, loc);
            }
            return DateFormat.getDateTimeInstance((Calendar)this.clone(), dateStyle, timeStyle, loc);
        }
        if (timeStyle != -1) {
            return DateFormat.getTimeInstance((Calendar)this.clone(), timeStyle, loc);
        }
        return null;
    }

    public DateFormat getDateTimeFormat(int dateStyle, int timeStyle, ULocale loc) {
        return this.getDateTimeFormat(dateStyle, timeStyle, loc.toLocale());
    }

    /*
     * Unable to fully structure code
     */
    public int fieldDifference(Date when, int field) {
        block11: {
            block10: {
                min = 0;
                startMs = this.getTimeInMillis();
                if (startMs >= (targetMs = when.getTime())) break block10;
                max = 1;
                do {
                    this.setTimeInMillis(startMs);
                    this.add(field, max);
                    ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return max;
                    }
                    if (ms > targetMs) ** GOTO lbl24
                } while ((max <<= 1) >= 0);
                throw new RuntimeException();
lbl-1000:
                // 1 sources

                {
                    t = (min + max) / 2;
                    this.setTimeInMillis(startMs);
                    this.add(field, t);
                    ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return t;
                    }
                    if (ms > targetMs) {
                        max = t;
                        continue;
                    }
                    min = t;
lbl24:
                    // 3 sources

                    ** while (max - min > 1)
                }
lbl25:
                // 1 sources

                break block11;
            }
            if (startMs <= targetMs) break block11;
            max = -1;
            do {
                this.setTimeInMillis(startMs);
                this.add(field, max);
                ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return max;
                }
                if (ms < targetMs) ** GOTO lbl48
            } while ((max <<= 1) != 0);
            throw new RuntimeException();
lbl-1000:
            // 1 sources

            {
                t = (min + max) / 2;
                this.setTimeInMillis(startMs);
                this.add(field, t);
                ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return t;
                }
                if (ms < targetMs) {
                    max = t;
                    continue;
                }
                min = t;
lbl48:
                // 3 sources

                ** while (min - max > 1)
            }
        }
        this.setTimeInMillis(startMs);
        this.add(field, min);
        return min;
    }

    public void setTimeZone(TimeZone value) {
        this.calendar.setTimeZone(value.timeZone);
    }

    public TimeZone getTimeZone() {
        return new TimeZone(this.calendar.getTimeZone());
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public void setFirstDayOfWeek(int value) {
        this.calendar.setFirstDayOfWeek(value);
    }

    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.calendar.setMinimalDaysInFirstWeek(value);
    }

    public int getMinimalDaysInFirstWeek() {
        return this.calendar.getMinimalDaysInFirstWeek();
    }

    public final int getMinimum(int field) {
        return this.calendar.getMinimum(Calendar.getJDKField(field));
    }

    public final int getMaximum(int field) {
        return this.calendar.getMaximum(Calendar.getJDKField(field));
    }

    public final int getGreatestMinimum(int field) {
        return this.calendar.getGreatestMinimum(Calendar.getJDKField(field));
    }

    public final int getLeastMaximum(int field) {
        return this.calendar.getLeastMaximum(Calendar.getJDKField(field));
    }

    public int getDayOfWeekType(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("illegal day of week: " + dayOfWeek);
        }
        if (dayOfWeek == 7 || dayOfWeek == 1) {
            return 1;
        }
        return 0;
    }

    public int getWeekendTransition(int dayOfWeek) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public boolean isWeekend(Date date) {
        this.calendar.setTime(date);
        return this.isWeekend();
    }

    public boolean isWeekend() {
        int dow = this.calendar.get(7);
        return dow == 7 || dow == 1;
    }

    public Object clone() {
        return new Calendar((java.util.Calendar)this.calendar.clone());
    }

    public String toString() {
        return this.calendar.toString();
    }

    public final int getFieldCount() {
        return 23;
    }

    public String getType() {
        String name = this.calendar.getClass().getSimpleName().toLowerCase(Locale.US);
        if (name.contains("japanese")) {
            return "japanese";
        }
        if (name.contains("buddhist")) {
            return "buddhist";
        }
        return "gregorian";
    }

    public final ULocale getLocale(ULocale.Type type) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    private static int getJDKField(int icuField) {
        switch (icuField) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                throw new UnsupportedOperationException("Calendar field type not supported by com.ibm.icu.base");
            }
        }
        throw new ArrayIndexOutOfBoundsException("Specified calendar field is out of range");
    }
}

