/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.vm;

import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import org.eclipse.equinox.jmx.common.util.MBeanInfoWrapper;
import org.eclipse.equinox.jmx.internal.vm.Activator;
import org.eclipse.equinox.jmx.internal.vm.VMStatsMessages;
import org.eclipse.equinox.jmx.server.Contribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeContribution
extends Contribution {
    private static final String ICON_PATH = "icons/runtime.gif";
    private MBeanInfo mbeanInfo;

    public RuntimeContribution(RuntimeMXBean delegate) {
        super((Object)delegate);
        this.mbeanInfo = MBeanInfoWrapper.createMBeanInfo(delegate.getClass(), (String)delegate.toString(), (MBeanAttributeInfo[])new MBeanAttributeInfo[0], (MBeanNotificationInfo[])new MBeanNotificationInfo[0]);
    }

    protected String getName() {
        return VMStatsMessages.rt_title;
    }

    protected Object[] getChildren() {
        return null;
    }

    protected Set<String> getProperties() {
        HashSet<String> result = new HashSet<String>();
        RuntimeMXBean mbean = (RuntimeMXBean)this.contributionDelegate;
        result.add(String.valueOf(VMStatsMessages.rt_vmname) + ": " + mbean.getVmName());
        result.add(String.valueOf(VMStatsMessages.rt_vmvendor) + ": " + mbean.getVmVendor());
        result.add(String.valueOf(VMStatsMessages.rt_vmversion) + ": " + mbean.getVmVersion());
        result.add(String.valueOf(VMStatsMessages.rt_starttime) + ": " + new Date(mbean.getStartTime()));
        result.add(String.valueOf(VMStatsMessages.rt_uptime) + ": " + new Date(mbean.getUptime()));
        result.add(String.valueOf(VMStatsMessages.rt_bootclasspath) + ": " + mbean.getBootClassPath());
        result.add(String.valueOf(VMStatsMessages.rt_systemclasspath) + ": " + mbean.getClassPath());
        result.add(String.valueOf(VMStatsMessages.rt_inputargs) + ": " + Arrays.toString(mbean.getInputArguments().toArray()));
        result.add(String.valueOf(VMStatsMessages.rt_ldpath) + ": " + mbean.getLibraryPath());
        result.add(String.valueOf(VMStatsMessages.rt_mgmtspecver) + ": " + mbean.getManagementSpecVersion());
        return result;
    }

    protected MBeanInfo getMBeanInfo(Object delegate) {
        return this.mbeanInfo;
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        return null;
    }

    public Object getAttribute(String attribute) {
        return null;
    }

    public void setAttribute(Attribute attribute) {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    protected URL getImageLocation() {
        return Activator.getImageLocation(ICON_PATH);
    }
}

