/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.util.Utils;

public class MBeanServerInvocationHandler
implements InvocationHandler {
    private final MBeanServerConnection connection;
    private final ObjectName objectName;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;

    public MBeanServerInvocationHandler(MBeanServerConnection connection, ObjectName objectName) {
        this.connection = connection;
        this.objectName = objectName;
    }

    public static Object newProxyInstance(MBeanServerConnection connection, ObjectName name, Class mbeanInterface, boolean notificationBroadcaster) {
        if (mbeanInterface == null) {
            throw new IllegalArgumentException("MBean interface cannot be null");
        }
        if (!mbeanInterface.isInterface()) {
            throw new IllegalArgumentException("Class parameter must be an interface");
        }
        if (name == null) {
            throw new IllegalArgumentException("MBean ObjectName cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("MBeanServerConnection cannot be null");
        }
        Class[] interfaces = null;
        interfaces = notificationBroadcaster && !mbeanInterface.equals(class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter) ? (mbeanInterface.equals(class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerInvocationHandler.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster) ? new Class[]{class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter} : new Class[]{mbeanInterface, class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter}) : new Class[]{mbeanInterface};
        ClassLoader loader = mbeanInterface.getClassLoader();
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new MBeanServerInvocationHandler(connection, name));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class[] declared = method.getExceptionTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerInvocationHandler.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster) || declaringClass.equals(class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter)) {
            return this.invokeNotificationMethod(proxy, method, args, declared);
        }
        if (Utils.isAttributeSetter((Method)method)) {
            String name = method.getName().substring(3);
            Attribute attribute = new Attribute(name, args[0]);
            try {
                this.connection.setAttribute(this.objectName, attribute);
                return null;
            }
            catch (Throwable x) {
                this.unwrapThrowable(x, declared);
            }
        } else if (Utils.isAttributeGetter((Method)method)) {
            String n = method.getName();
            String name = null;
            name = n.startsWith("is") ? n.substring(2) : n.substring(3);
            try {
                return this.connection.getAttribute(this.objectName, name);
            }
            catch (Throwable x) {
                this.unwrapThrowable(x, declared);
            }
        } else {
            Class<?>[] parameters = method.getParameterTypes();
            String[] params = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                params[i] = parameters[i].getName();
            }
            try {
                return this.connection.invoke(this.objectName, method.getName(), args, params);
            }
            catch (Throwable x) {
                this.unwrapThrowable(x, declared);
            }
        }
        return null;
    }

    private Object invokeNotificationMethod(Object proxy, Method method, Object[] args, Class[] declared) throws Throwable {
        int numArgs;
        String methodName = method.getName();
        int n = numArgs = args == null ? 0 : args.length;
        if (methodName.equals("addNotificationListener")) {
            try {
                this.connection.addNotificationListener(this.objectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
            }
            catch (Throwable t) {
                this.unwrapThrowable(t, declared);
            }
            return null;
        }
        if (methodName.equals("removeNotificationListener")) {
            switch (numArgs) {
                case 1: {
                    try {
                        this.connection.removeNotificationListener(this.objectName, (NotificationListener)args[0]);
                    }
                    catch (Throwable t) {
                        this.unwrapThrowable(t, declared);
                    }
                    return null;
                }
                case 3: {
                    try {
                        this.connection.removeNotificationListener(this.objectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    }
                    catch (Throwable t) {
                        this.unwrapThrowable(t, declared);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("Method removeNotificationListener must have 1 or 3 arguments");
        }
        if (methodName.equals("getNotificationInfo")) {
            try {
                MBeanInfo info = this.connection.getMBeanInfo(this.objectName);
                return info.getNotifications();
            }
            catch (Throwable t) {
                this.unwrapThrowable(t, declared);
                return null;
            }
        }
        throw new IllegalArgumentException("Method " + methodName + " not known to MBean: " + this.objectName);
    }

    private void unwrapThrowable(Throwable x, Class[] declared) throws Throwable {
        if (declared != null) {
            for (int i = 0; i < declared.length; ++i) {
                Class exception = declared[i];
                if (!exception.isInstance(x)) continue;
                throw x;
            }
        }
        if (x instanceof MBeanException) {
            this.unwrapThrowable(((MBeanException)x).getTargetException(), declared);
        } else if (x instanceof ReflectionException) {
            this.unwrapThrowable(((ReflectionException)x).getTargetException(), declared);
        } else if (x instanceof RuntimeOperationsException) {
            this.unwrapThrowable(((RuntimeOperationsException)x).getTargetException(), declared);
        } else if (x instanceof RuntimeMBeanException) {
            this.unwrapThrowable(((RuntimeMBeanException)x).getTargetException(), declared);
        } else if (x instanceof RuntimeErrorException) {
            this.unwrapThrowable(((RuntimeErrorException)x).getTargetError(), declared);
        } else {
            throw x;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

