/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultsWriter;

public class RowSetOps {
    private RowSetOps() {
    }

    public static void consume(RowSet rowSet) {
        RowSetOps.count(rowSet);
    }

    public static long count(RowSet rowSet) {
        return rowSet.rewindable().size();
    }

    public static void out(RowSet rowSet) {
        RowSetOps.out((OutputStream)System.out, rowSet);
    }

    public static void out(OutputStream out, RowSet rowSet) {
        RowSetOps.out(out, rowSet, (PrefixMap)null);
    }

    public static void out(OutputStream out, RowSet resultSet, PrefixMap pmap) {
        PrefixMapping prefixMapping = pmap == null ? null : Prefixes.adapt(pmap);
        Prologue prologue = new Prologue(prefixMapping);
        RowSetOps.out(out, resultSet, prologue);
    }

    public static void out(OutputStream out, RowSet rowSet, Prologue prologue) {
        ResultsWriter.create().lang(ResultSetLang.RS_Text).set(ARQConstants.symPrologue, prologue).write(out, ResultSet.adapt(rowSet));
    }

    public static void out(boolean answer) {
        RowSetOps.out((OutputStream)System.out, answer);
    }

    public static void out(OutputStream out, boolean answer) {
        ResultsWriter.create().lang(ResultSetLang.RS_Text).write(out, answer);
    }

    private static void materialize(QuerySolution qs) {
        Iterator<String> iter = qs.varNames();
        while (iter.hasNext()) {
            String vn = iter.next();
            RDFNode rDFNode = qs.get(vn);
        }
    }
}

