/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStorePropertiesSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private static final String EMFSTORE_PROPERTIES_MONITOR = "EmfStorePropertiesMonitor";
    private final Map<ProjectHistory, Map<String, EMFStoreProperty>> cache = new LinkedHashMap<ProjectHistory, Map<String, EMFStoreProperty>>();

    public EMFStorePropertiesSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.SETEMFPROPERTIES)
    public List<EMFStoreProperty> setEMFProperties(List<EMFStoreProperty> properties, ProjectId projectId) throws ESException {
        this.sanityCheckObjects(properties, projectId);
        Object object = MonitorProvider.getInstance().getMonitor(EMFSTORE_PROPERTIES_MONITOR);
        synchronized (object) {
            ArrayList<EMFStoreProperty> rejectedProperties = new ArrayList<EMFStoreProperty>();
            ProjectHistory history = this.findHistory(projectId);
            if (history == null) {
                throw new ESException(Messages.EMFStorePropertiesSubInterfaceImpl_Project_Does_Not_Exist);
            }
            EList sharedProperties = history.getSharedProperties();
            LinkedHashSet<EMFStoreProperty> replacedProperties = new LinkedHashSet<EMFStoreProperty>();
            for (EMFStoreProperty property : properties) {
                EMFStoreProperty foundProperty = this.findProperty(history, property.getKey());
                if (foundProperty == null) {
                    sharedProperties.add((Object)property);
                    this.updateCache(history, property);
                    if (!property.isVersioned()) continue;
                    property.increaseVersion();
                    continue;
                }
                if (property.isVersioned()) {
                    if (property.getVersion() == foundProperty.getVersion()) {
                        sharedProperties.set(sharedProperties.indexOf((Object)foundProperty), (Object)property);
                        replacedProperties.add(foundProperty);
                        property.increaseVersion();
                        continue;
                    }
                    rejectedProperties.add(foundProperty);
                    continue;
                }
                sharedProperties.set(sharedProperties.indexOf((Object)foundProperty), (Object)property);
                replacedProperties.add(foundProperty);
            }
            try {
                this.getServerSpace().save();
            }
            catch (IOException e) {
                sharedProperties.removeAll(properties);
                sharedProperties.addAll(replacedProperties);
                throw new ESException(Messages.EMFStorePropertiesSubInterfaceImpl_Properties_Not_Set, e);
            }
            return rejectedProperties;
        }
    }

    @ESMethod(value=ESMethod.MethodId.GETEMFPROPERTIES)
    public List<EMFStoreProperty> getEMFProperties(ProjectId projectId) throws ESException {
        this.sanityCheckObjects(projectId);
        ProjectHistory history = this.findHistory(projectId);
        if (history != null) {
            ArrayList<EMFStoreProperty> temp = new ArrayList<EMFStoreProperty>();
            for (EMFStoreProperty prop : history.getSharedProperties()) {
                temp.add(prop);
            }
            return temp;
        }
        throw new ESException("The Project does not exist on the server. Cannot set the properties.");
    }

    private ProjectHistory findHistory(ProjectId projectId) {
        EList serverProjects = this.getServerSpace().getProjects();
        for (ProjectHistory history : serverProjects) {
            if (!history.getProjectId().equals(projectId)) continue;
            return history;
        }
        return null;
    }

    private EMFStoreProperty findProperty(ProjectHistory projectHistory, String propertyName) {
        Map<String, EMFStoreProperty> propertiesMap = this.initCacheForHistory(projectHistory);
        return propertiesMap.get(propertyName);
    }

    private Map<String, EMFStoreProperty> initCacheForHistory(ProjectHistory projectHistory) {
        Map<String, EMFStoreProperty> propertiesMap = this.cache.get(projectHistory);
        if (propertiesMap == null) {
            propertiesMap = new LinkedHashMap<String, EMFStoreProperty>();
            for (EMFStoreProperty prop : projectHistory.getSharedProperties()) {
                propertiesMap.put(prop.getKey(), prop);
            }
        }
        return propertiesMap;
    }

    private void updateCache(ProjectHistory history, EMFStoreProperty property) {
        Map<String, EMFStoreProperty> properties = this.initCacheForHistory(history);
        properties.put(property.getKey(), property);
    }
}

