/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionRegistry {
    public static final ExtensionRegistry INSTANCE = new ExtensionRegistry();
    private final Map<String, ESConfigElement> configElements = new HashMap<String, ESConfigElement>();

    private ExtensionRegistry() {
    }

    public <T> T get(String id, Class<T> clazz, T defaultInstance, boolean shouldSetDefault) {
        Object t;
        T extensionPointInstnace = this.getExtensionElement(id, clazz);
        if (extensionPointInstnace != null) {
            return extensionPointInstnace;
        }
        ESConfigElement configElement = this.configElements.get(id);
        if (configElement != null) {
            t = configElement.get();
        } else {
            t = defaultInstance;
            if (shouldSetDefault) {
                this.set(id, t);
            }
        }
        return t;
    }

    public <T> T get(String id, Class<T> clazz) {
        return this.get(id, clazz, null, false);
    }

    public <T> void set(String id, T t) {
        this.configElements.put(id, new ESConfigElement(t));
    }

    private <T> T getExtensionElement(String id, Class<T> t) {
        int idx = id.lastIndexOf(46);
        String extensionPointId = id.substring(0, idx);
        String attributeName = id.substring(idx + 1, id.length());
        ESExtensionPoint extensionPoint = new ESExtensionPoint(extensionPointId);
        if (extensionPoint.getFirst() == null) {
            return null;
        }
        return extensionPoint.getFirst().getClass(attributeName, t);
    }

    public void remove(String id) {
        this.configElements.remove(id);
    }

    class ESConfigElement {
        private Object t;

        public ESConfigElement(Object o) {
            this.t = o;
        }

        public Object get() {
            return this.t;
        }

        public void set(Object t) {
            this.t = t;
        }
    }
}

