/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.login;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.AbstractLoginDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.ILoginDialogController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.Messages;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class LoginDialog
extends AbstractLoginDialog {
    private static final String CLIENT_UI_BUNDLE = "org.eclipse.emf.emfstore.client.ui.rap";
    private static final String LOGIN_ICON = "icons/login_icon.png";
    private Text passwordField;
    private ComboViewer usernameCombo;
    private List<Usersession> knownUsersessions;

    public LoginDialog(Shell parentShell, ILoginDialogController controller) {
        super(parentShell, controller);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage((String)CLIENT_UI_BUNDLE, (String)LOGIN_ICON));
        this.setTitle(String.valueOf(Messages.LoginDialog_Login_To) + this.getController().getServer().getName());
        this.setMessage(Messages.LoginDialog_Enter_Name_And_Password);
        this.getShell().setText(Messages.LoginDialog_Auth_Required);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite loginContainer = new Composite(container, 0);
        loginContainer.setLayout((Layout)new GridLayout(3, false));
        loginContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        loginContainer.setBounds(0, 0, 64, 64);
        this.createUsernameLabel(loginContainer);
        this.createUsernameCombo(loginContainer);
        this.createPasswordLabel(loginContainer);
        this.createPasswordField(loginContainer);
        this.initData();
        if (this.getController().getUsersession() == null) {
            ESUsersession lastUsersession = this.getController().getServer().getLastUsersession();
            if (lastUsersession != null) {
                this.loadUsersession((Usersession)((ESUsersessionImpl)lastUsersession).toInternalAPI());
            } else {
                this.loadUsersession(null);
            }
        } else {
            ESUsersession usersession = this.getController().getUsersession();
            this.loadUsersession((Usersession)((ESUsersessionImpl)usersession).toInternalAPI());
        }
        return area;
    }

    private void createPasswordField(Composite parent) {
        this.passwordField = new Text(parent, 0x400800);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 300;
        this.passwordField.setLayoutData((Object)gridData);
        this.passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.setPasswordModified(true);
                LoginDialog.this.flushErrorMessage();
            }
        });
        new Label(parent, 0);
    }

    private void createPasswordLabel(Composite parent) {
        Label passwordLabel = new Label(parent, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 80;
        passwordLabel.setLayoutData((Object)gridData);
        passwordLabel.setText(Messages.LoginDialog_Password);
    }

    private void createUsernameLabel(Composite parent) {
        Label usernameLabel = new Label(parent, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 95;
        usernameLabel.setLayoutData((Object)gridData);
        usernameLabel.setText(Messages.LoginDialog_Username);
    }

    private void createUsernameCombo(Composite parent) {
        this.usernameCombo = new ComboViewer(parent, 0);
        ComboListener comboListener = new ComboListener();
        this.usernameCombo.addPostSelectionChangedListener((ISelectionChangedListener)comboListener);
        Combo combo = this.usernameCombo.getCombo();
        combo.addModifyListener((ModifyListener)comboListener);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 285;
        combo.setLayoutData((Object)gridData);
        new Label(parent, 0);
    }

    private void initData() {
        this.usernameCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.usernameCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Usersession && ((Usersession)element).getUsername() != null) {
                    return ((Usersession)element).getUsername();
                }
                return super.getText(element);
            }
        });
        this.knownUsersessions = APIUtil.mapToInternalAPI(Usersession.class, (List)this.getController().getKnownUsersessions());
        this.usernameCombo.setInput(this.knownUsersessions);
    }

    private void loadUsersession(Usersession usersession) {
        if (usersession != null && this.getSelectedUsersession() == usersession) {
            return;
        }
        this.setSelectedSession(usersession);
        this.passwordField.setMessage("");
        if (this.getSelectedUsersession() != null) {
            if (!this.usernameCombo.getCombo().getText().equals(this.getSelectedUsersession().getUsername())) {
                this.usernameCombo.getCombo().setText(this.getSelectedUsersession().getUsername());
            }
            if (this.getSelectedUsersession().isSavePassword() && this.getSelectedUsersession().getPassword() != null) {
                this.passwordField.setMessage(Messages.LoginDialog_Password_Saved_Reenter_To_Change);
                this.passwordField.setText("");
            }
            this.setPasswordModified(false);
        }
    }

    protected void okPressed() {
        final String username = this.usernameCombo.getCombo().getText();
        Usersession candidateSession = this.getSelectedUsersession();
        ESServerImpl server = (ESServerImpl)this.getController().getServer();
        if (candidateSession == null) {
            candidateSession = this.getUsersessionIfKnown(username);
        }
        if (candidateSession == null || !candidateSession.getServerInfo().equals(server.toInternalAPI())) {
            final ESServerImpl serverImpl = (ESServerImpl)this.getController().getServer();
            final Usersession session = candidateSession = ModelFactory.eINSTANCE.createUsersession();
            this.setSelectedSession(candidateSession);
            RunESCommand.run((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    session.setServerInfo((ServerInfo)serverImpl.toInternalAPI());
                    session.setUsername(username);
                    return null;
                }
            });
        }
        this.setPassword(this.passwordField.getText());
        super.okPressed();
    }

    private Usersession getUsersessionIfKnown(String username) {
        if (this.getSelectedUsersession() != null && this.getSelectedUsersession().getUsername().equals(username)) {
            return this.getSelectedUsersession();
        }
        for (Usersession session : this.knownUsersessions) {
            if (!session.getUsername().equals(username)) continue;
            return session;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.LoginDialog_Ok, true);
        this.createButton(parent, 1, Messages.LoginDialog_Cancel, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    private void flushErrorMessage() {
        this.setErrorMessage(null);
    }

    private final class ComboListener
    implements ISelectionChangedListener,
    ModifyListener {
        private String lastText = "";

        private ComboListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof Usersession) {
                LoginDialog.this.loadUsersession((Usersession)firstElement);
            }
        }

        public void modifyText(ModifyEvent e) {
            String text = LoginDialog.this.usernameCombo.getCombo().getText();
            if (StringUtils.isNotBlank((String)text) && !text.equals(this.lastText)) {
                LoginDialog.this.loadUsersession(LoginDialog.this.getUsersessionIfKnown(text));
                this.lastText = text;
            }
            LoginDialog.this.flushErrorMessage();
        }
    }
}

