/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl.CreateDeleteOperationImpl;

public class ResourceHelper {
    private final ServerSpace serverSpace;

    public ResourceHelper(ServerSpace serverSpace) throws FatalESException {
        this.serverSpace = serverSpace;
    }

    public void createResourceForProjectHistory(ProjectHistory projectHistory) throws FatalESException {
        String fileName = String.valueOf(this.getProjectFolder(projectHistory.getProjectId())) + "projectHistory" + ".uph";
        this.saveInResource((EObject)projectHistory, fileName);
    }

    public void createResourceForVersion(Version version, ProjectId projectId) throws FatalESException {
        String fileName = String.valueOf(this.getProjectFolder(projectId)) + "version-" + version.getPrimarySpec().getIdentifier() + ".upv";
        this.saveInResource((EObject)version, fileName);
    }

    public void createResourceForProject(Project project, PrimaryVersionSpec versionId, ProjectId projectId) throws FatalESException {
        String filename = String.valueOf(this.getProjectFolder(projectId)) + this.getProjectFile(versionId.getIdentifier());
        this.saveInResourceWithProject((EObject)project, filename, project);
    }

    public void createResourceForChangePackage(ChangePackage changePackage, PrimaryVersionSpec versionId, ProjectId projectId) throws FatalESException {
        String filename = String.valueOf(this.getProjectFolder(projectId)) + this.getChangePackageFile(versionId.getIdentifier());
        ArrayList<Map.Entry> ignoredDatatypes = new ArrayList<Map.Entry>();
        for (AbstractOperation op : changePackage.getOperations()) {
            if (!(op instanceof CreateDeleteOperation)) continue;
            CreateDeleteOperation createDeleteOp = (CreateDeleteOperation)op;
            for (Map.Entry e : ((CreateDeleteOperationImpl)createDeleteOp).getEObjectToIdMap().entrySet()) {
                EObject modelElement = (EObject)e.getKey();
                if (!ModelUtil.isIgnoredDatatype((EObject)modelElement)) continue;
                ignoredDatatypes.add(e);
            }
            createDeleteOp.getEObjectToIdMap().removeAll(ignoredDatatypes);
        }
        this.saveInResource((EObject)changePackage, filename);
    }

    public void deleteProjectState(Version version, ProjectId projectId) {
        int lastVersion = version.getPrimarySpec().getIdentifier();
        Resource projectResource = version.getProjectState().eResource();
        File file = new File(String.valueOf(this.getProjectFolder(projectId)) + this.getProjectFile(lastVersion));
        file.delete();
        if (projectResource.isLoaded()) {
            projectResource.unload();
        }
    }

    public int getXFromPolicy(String policy, String defaultPolicy, boolean allowZero) {
        int x;
        try {
            x = Integer.parseInt(ServerConfiguration.getProperties().getProperty(policy, defaultPolicy));
        }
        catch (NumberFormatException e) {
            x = 1;
            ModelUtil.logWarning((String)("Couldn't read property: " + policy + " , x set to 1"), (Throwable)e);
        }
        if (x < 0) {
            x = 1;
            ModelUtil.logWarning((String)("Policy " + policy + " with x < 0 not possible, x set to 1."));
        }
        if (!allowZero && x == 0) {
            x = 1;
            ModelUtil.logWarning((String)("Policy " + policy + " with x = 0 not possible, x set to 1."));
        }
        return x;
    }

    public String getProjectFolder(ProjectId projectId) {
        return String.valueOf(ServerConfiguration.getServerHome()) + "project-" + projectId.getId() + File.separatorChar;
    }

    private String getProjectFile(int versionNumber) {
        return "projectstate-" + versionNumber + ".ups";
    }

    private String getChangePackageFile(int versionNumber) {
        return "changepackage-" + versionNumber + ".ucp";
    }

    private void saveInResource(EObject obj, String fileName) throws FatalESException {
        Resource resource = this.serverSpace.eResource().getResourceSet().createResource(URI.createFileURI((String)fileName));
        resource.getContents().add((Object)obj);
        this.save(obj);
    }

    private void saveInResourceWithProject(EObject obj, String fileName, Project project) throws FatalESException {
        Resource resource = this.serverSpace.eResource().getResourceSet().createResource(URI.createFileURI((String)fileName));
        resource.getContents().add((Object)obj);
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (EObject modelElement : project.getAllModelElements()) {
                ModelElementId modelElementId = project.getModelElementId(modelElement);
                xmiResource.setID(modelElement, modelElementId.getId());
            }
        }
        this.save(obj);
    }

    public void saveWithProject(EObject eObject, Project project) throws FatalESException {
        Resource resource = eObject.eResource();
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (EObject modelElement : project.getAllModelElements()) {
                ModelElementId modelElementId = project.getModelElementId(modelElement);
                xmiResource.setID(modelElement, modelElementId.getId());
            }
        }
        this.save(eObject);
    }

    public void save(EObject object) throws FatalESException {
        try {
            ModelUtil.saveResource((Resource)object.eResource(), (IResourceLogger)ModelUtil.getResourceLogger());
        }
        catch (Exception e) {
            throw new FatalESException("Couldn't save data in database.", e);
        }
    }

    public void saveAll() throws FatalESException {
        for (Resource res : this.serverSpace.eResource().getResourceSet().getResources()) {
            if (!res.isLoaded() || !res.isModified()) continue;
            try {
                ModelUtil.saveResource((Resource)res, (IResourceLogger)ModelUtil.getResourceLogger());
            }
            catch (Exception e) {
                throw new FatalESException("Couldn't save data in database.", e);
            }
        }
    }
}

