/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.ProjectSpaceContainer;
import org.eclipse.emf.emfstore.internal.client.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.BranchGraphLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.CommitInfoColumnLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.ESBrowserLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.HistorySCMLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.LogMessageColumnLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotCommitProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotLane;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.SWTPlotRenderer;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.SCMContentProvider;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESHistoryInfoImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ModelElementQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.util.HistoryQueryBuilder;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.query.ESHistoryQuery;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryBrowserView
extends ViewPart
implements ProjectSpaceContainer {
    private static final int UPPER_LIMIT = 10;
    private static final int LOWER_LIMIT = 20;
    private ProjectSpace projectSpace;
    private EObject modelElement;
    private List<HistoryInfo> infos;
    private PrimaryVersionSpec centerVersion;
    private boolean showAllVersions;
    private TreeViewerWithModelElementSelectionProvider viewer;
    private SWTPlotRenderer renderer;
    private Link noProjectHint;
    private TreeViewerColumn changeColumn;
    private TreeViewerColumn branchColumn;
    private TreeViewerColumn commitColumn;
    private TreeViewerColumn authorColumn;
    private static final int BRANCH_COLUMN = 1;
    private SCMContentProvider contentProvider;
    private PlotCommitProvider commitProvider;
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private HistorySCMLabelProvider changeLabel;
    private LogMessageColumnLabelProvider commitLabel;
    private ExpandCollapseAction expandAndCollapse;
    private boolean isUnlinkedFromNavigator;
    private Action showAllBranches;

    public ProjectSpace getProjectSpace() {
        if (this.isUnlinkedFromNavigator) {
            return null;
        }
        return this.projectSpace;
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.initNoProjectHint(parent);
        this.viewer = new TreeViewerWithModelElementSelectionProvider(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.initMenuManager();
        this.changeColumn = this.createColumn("Changes", 250);
        this.branchColumn = this.createColumn("Branches", 150);
        this.commitColumn = this.createColumn("Commit Message", 250);
        this.authorColumn = this.createColumn("Author and Date", 250);
        this.initContentAndLabelProvider();
        this.initGraphRenderer();
        this.initToolBar();
        this.initProjectDeleteListener();
    }

    private void initContentAndLabelProvider() {
        this.contentProvider = new SCMContentProvider();
        this.commitProvider = new PlotCommitProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.changeLabel = new HistorySCMLabelProvider();
        this.changeColumn.setLabelProvider((CellLabelProvider)this.changeLabel);
        this.branchColumn.setLabelProvider((CellLabelProvider)new BranchGraphLabelProvider());
        this.commitLabel = new LogMessageColumnLabelProvider();
        this.commitColumn.setLabelProvider((CellLabelProvider)this.commitLabel);
        this.authorColumn.setLabelProvider((CellLabelProvider)new CommitInfoColumnLabelProvider());
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    private void initGraphRenderer() {
        this.renderer = new SWTPlotRenderer(this.viewer.getTree().getDisplay());
        this.viewer.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                HistoryBrowserView.this.doPaint(event);
            }
        });
    }

    private void doPaint(Event event) {
        if (event.index != 1) {
            return;
        }
        TreeItem currItem = (TreeItem)event.item;
        Object data = currItem.getData();
        boolean isCommitItem = true;
        while (!(data instanceof HistoryInfo)) {
            isCommitItem = false;
            if ((currItem = currItem.getParentItem()) == null) {
                return;
            }
            data = currItem.getData();
        }
        IPlotCommit c = this.commitProvider.getCommitFor((HistoryInfo)data, !isCommitItem);
        PlotLane lane = c.getLane();
        if (lane != null && lane.getSaturatedColor().isDisposed()) {
            return;
        }
        event.gc.setFont(PlatformUI.getWorkbench().getDisplay().getSystemFont());
        this.renderer.paint(event, c);
    }

    private TreeViewerColumn createColumn(String label, int width) {
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.viewer, 2);
        column.getColumn().setText(label);
        column.getColumn().setWidth(width);
        return column;
    }

    private void initMenuManager() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void refresh() {
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HistoryBrowserView.this.setDescription();
                return null;
            }
        });
        this.resetExpandCollapse();
        if (this.projectSpace == null || this.modelElement == null) {
            this.viewer.setInput(Collections.EMPTY_LIST);
            return;
        }
        this.infos = this.getHistoryInfos();
        this.addBaseVersionTag(this.infos);
        this.resetProviders(this.infos);
        this.viewer.setInput(this.infos);
    }

    private void addBaseVersionTag(List<HistoryInfo> infos) {
        HistoryInfo historyInfo = this.getHistoryInfo(this.projectSpace.getBaseVersion());
        if (historyInfo != null) {
            historyInfo.getTagSpecs().add((Object)Versions.createTAG((String)"BASE", (String)"___GLOBAL___"));
        }
    }

    private void resetExpandCollapse() {
        this.expandAndCollapse.setChecked(false);
        this.expandAndCollapse.setImage(true);
    }

    private void setDescription() {
        if (this.projectSpace == null) {
            this.setContentDescription("No element selected.");
            this.showNoProjectHint(true);
            return;
        }
        String label = "History for ";
        label = this.modelElement == this.projectSpace ? String.valueOf(label) + this.projectSpace.getProjectName() + " [" + this.projectSpace.getBaseVersion().getBranch() + "]" : String.valueOf(label) + this.adapterFactoryLabelProvider.getText((Object)this.modelElement);
        this.showNoProjectHint(false);
        this.setContentDescription(label);
    }

    private List<HistoryInfo> getHistoryInfos() {
        Shell shell = this.getViewSite().getShell();
        List result = (List)new AbstractEMFStoreUIController<List<HistoryInfo>>(shell, true, false){

            @Override
            public List<HistoryInfo> doRun(IProgressMonitor monitor) throws ESException {
                return (List)new UnknownEMFStoreWorkloadCommand<List<HistoryInfo>>(monitor){

                    public List<HistoryInfo> run(IProgressMonitor monitor) throws ESException {
                        List historyInfosFromServer = HistoryBrowserView.this.getHistoryInfosFromServer(monitor);
                        return historyInfosFromServer;
                    }
                }.execute();
            }
        }.execute();
        return result != null ? result : new ArrayList();
    }

    private List<HistoryInfo> getHistoryInfosFromServer(final IProgressMonitor monitor) throws ESException {
        return (List)new ServerCall<List<HistoryInfo>>(this.projectSpace){

            protected List<HistoryInfo> run() throws ESException {
                monitor.beginTask("Fetching history form server", 100);
                List historyInfos = HistoryBrowserView.this.getLocalChanges();
                monitor.worked(10);
                if (HistoryBrowserView.this.projectSpace != HistoryBrowserView.this.modelElement) {
                    List infos = HistoryBrowserView.this.modelElementQuery();
                    for (ESHistoryInfo info : infos) {
                        historyInfos.add((HistoryInfo)((ESHistoryInfoImpl)info).toInternalAPI());
                    }
                } else {
                    List infos = HistoryBrowserView.this.rangeQuery();
                    for (ESHistoryInfo info : infos) {
                        historyInfos.add((HistoryInfo)((ESHistoryInfoImpl)info).toInternalAPI());
                    }
                }
                monitor.worked(90);
                return historyInfos;
            }
        }.execute();
    }

    private List<ESHistoryInfo> modelElementQuery() throws ESException {
        ModelElementQuery query = HistoryQueryBuilder.modelelementQuery((PrimaryVersionSpec)this.centerVersion, Arrays.asList(ModelUtil.getModelElementId((EObject)this.modelElement)), (int)10, (int)20, (boolean)this.showAllVersions, (boolean)true);
        ESHistoryQuery api = (ESHistoryQuery)query.toAPI();
        List infos = ((ESLocalProjectImpl)this.projectSpace.toAPI()).getHistoryInfos(api, (IProgressMonitor)new NullProgressMonitor());
        return infos;
    }

    private List<ESHistoryInfo> rangeQuery() throws ESException {
        RangeQuery rangeQuery = HistoryQueryBuilder.rangeQuery((PrimaryVersionSpec)this.centerVersion, (int)10, (int)20, (boolean)this.showAllVersions, (boolean)true, (boolean)true, (boolean)true);
        List infos = ((ESLocalProjectImpl)this.projectSpace.toAPI()).getHistoryInfos((ESHistoryQuery)rangeQuery.toAPI(), (IProgressMonitor)new NullProgressMonitor());
        return infos;
    }

    private List<HistoryInfo> getLocalChanges() {
        ArrayList<HistoryInfo> revisions = new ArrayList<HistoryInfo>();
        if (this.projectSpace != null) {
            HistoryInfo localHistoryInfo = VersioningFactory.eINSTANCE.createHistoryInfo();
            ChangePackage changePackage = this.projectSpace.getLocalChangePackage(false);
            if (this.modelElement != null && this.projectSpace.getProject().contains(this.modelElement)) {
                LinkedHashSet<AbstractOperation> operationsToRemove = new LinkedHashSet<AbstractOperation>();
                for (AbstractOperation ao : changePackage.getOperations()) {
                    if (ao.getAllInvolvedModelElements().contains(ModelUtil.getProject((EObject)this.modelElement).getModelElementId(this.modelElement))) continue;
                    operationsToRemove.add(ao);
                }
                changePackage.getOperations().removeAll(operationsToRemove);
            }
            localHistoryInfo.setChangePackage(changePackage);
            PrimaryVersionSpec versionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            versionSpec.setIdentifier(-1);
            localHistoryInfo.setPrimarySpec(versionSpec);
            localHistoryInfo.setPreviousSpec((PrimaryVersionSpec)ModelUtil.clone((EObject)this.projectSpace.getBaseVersion()));
            revisions.add(localHistoryInfo);
        }
        return revisions;
    }

    private void resetProviders(List<HistoryInfo> infos) {
        ArrayList<ChangePackage> cps = new ArrayList<ChangePackage>();
        for (HistoryInfo info : infos) {
            if (info.getChangePackage() == null) continue;
            cps.add(info.getChangePackage());
        }
        ChangePackageVisualizationHelper newHelper = new ChangePackageVisualizationHelper((ModelElementIdToEObjectMapping)new ModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this.projectSpace.getProject(), cps));
        this.changeLabel.setProject(this.projectSpace.getProject());
        this.changeLabel.setChangePackageVisualizationHelper(newHelper);
        this.commitLabel.setProject(this.projectSpace.getProject());
        this.commitLabel.setChangePackageVisualizationHelper(newHelper);
        this.commitProvider.reset(infos);
    }

    public void setInput(EObject input) {
        try {
            if (input instanceof ProjectSpace) {
                this.projectSpace = (ProjectSpace)input;
            } else if (input != null) {
                ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
                this.projectSpace = ((Workspace)workspace.toInternalAPI()).getProjectSpace(ModelUtil.getProject((EObject)input));
            } else {
                this.projectSpace = null;
            }
            this.modelElement = input;
            this.showAll(true);
            this.setCenterVersion();
            this.refresh();
        }
        catch (ESException eSException) {}
    }

    public void setInput(ESLocalProject localProject) {
        this.setInput((EObject)localProject);
    }

    private void showAll(boolean show) {
        this.showAllVersions = show;
        this.showAllBranches.setChecked(show);
    }

    private void setCenterVersion() {
        this.centerVersion = this.projectSpace != null ? this.projectSpace.getBaseVersion() : null;
    }

    private void showNoProjectHint(boolean b) {
        this.noProjectHint.setVisible(b);
        this.noProjectHint.getParent().layout();
    }

    private void initNoProjectHint(final Composite parent) {
        this.noProjectHint = new Link(parent, 64);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)this.noProjectHint);
        this.noProjectHint.setText("Select a <a>project</a> or call 'Show history' from the context menu of an element in the navigator.");
        this.noProjectHint.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                ProjectSpace resultSelection;
                ElementListSelectionDialog elsd = new ElementListSelectionDialog(parent.getShell(), (ILabelProvider)new ESBrowserLabelProvider());
                ArrayList<ProjectSpace> relevantProjectSpaces = new ArrayList<ProjectSpace>();
                ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
                Object[] objectArray = ((Workspace)workspace.toInternalAPI()).getProjectSpaces().iterator();
                while (objectArray.hasNext()) {
                    ProjectSpace ps = (ProjectSpace)objectArray.next();
                    if (ps.getUsersession() == null) continue;
                    relevantProjectSpaces.add(ps);
                }
                elsd.setElements(relevantProjectSpaces.toArray());
                elsd.setMultipleSelection(false);
                elsd.setTitle("Select a project from the workspace");
                elsd.setMessage("Please select a project from the current workspace.");
                if (elsd.open() == 0 && (objectArray = elsd.getResult()).length != 0 && (resultSelection = (ProjectSpace)(o = objectArray[0])) != null) {
                    HistoryBrowserView.this.setInput((EObject)resultSelection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void initProjectDeleteListener() {
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new DeleteProjectSpaceObserver(){

            public void projectSpaceDeleted(ProjectSpace projectSpace) {
                if (HistoryBrowserView.this.projectSpace == projectSpace) {
                    HistoryBrowserView.this.setInput((EObject)null);
                }
            }
        });
    }

    public void dispose() {
        this.adapterFactoryLabelProvider.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager menuManager = bars.getToolBarManager();
        this.addRefreshAction(menuManager);
        this.addShowAllBranchesAction(menuManager);
        this.addExpandAllAndCollapseAllAction(menuManager);
        this.addNextAndPreviousAction(menuManager);
        this.addJumpToRevisionAction(menuManager);
        this.addLinkWithNavigatorAction(menuManager);
    }

    private void addRefreshAction(IToolBarManager menuManager) {
        Action refresh = new Action(){

            public void run() {
                HistoryBrowserView.this.refresh();
            }
        };
        refresh.setImageDescriptor(Activator.getImageDescriptor("/icons/refresh.png"));
        refresh.setToolTipText("Refresh");
        menuManager.add((IAction)refresh);
    }

    private void addNextAndPreviousAction(IToolBarManager menuManager) {
        Action prev = new Action(){

            public void run() {
                HistoryBrowserView.this.centerVersion = HistoryBrowserView.this.prevNextCenter(false);
                HistoryBrowserView.this.refresh();
            }
        };
        prev.setImageDescriptor(Activator.getImageDescriptor("/icons/prev.png"));
        prev.setToolTipText("Previous items");
        menuManager.add((IAction)prev);
        Action next = new Action(){

            public void run() {
                HistoryBrowserView.this.centerVersion = HistoryBrowserView.this.prevNextCenter(true);
                HistoryBrowserView.this.refresh();
            }
        };
        next.setImageDescriptor(Activator.getImageDescriptor("/icons/next.png"));
        next.setToolTipText("Next items");
        menuManager.add((IAction)next);
    }

    private PrimaryVersionSpec prevNextCenter(boolean next) {
        if (this.projectSpace == null || this.centerVersion == null) {
            return null;
        }
        if (this.showAllVersions) {
            return this.biggestOrSmallesInfo(next);
        }
        if (!this.projectSpace.getBaseVersion().getBranch().equals(this.centerVersion.getBranch())) {
            return this.projectSpace.getBaseVersion();
        }
        HistoryInfo current = this.getHistoryInfo(this.centerVersion);
        while (current != null) {
            if (next) {
                if (current.getNextSpec().size() <= 0) break;
                HistoryInfo nextInfo = this.getHistoryInfo((PrimaryVersionSpec)current.getNextSpec().get(0));
                if (nextInfo == null) {
                    return current.getPrimarySpec();
                }
                current = nextInfo;
                continue;
            }
            if (current.getPreviousSpec() == null || !current.getPreviousSpec().getBranch().equals(this.projectSpace.getBaseVersion().getBranch())) break;
            HistoryInfo prevInfo = this.getHistoryInfo(current.getPreviousSpec());
            if (prevInfo == null) {
                return current.getPrimarySpec();
            }
            current = prevInfo;
        }
        if (current == null) {
            return this.centerVersion;
        }
        return current.getPrimarySpec();
    }

    private HistoryInfo getHistoryInfo(PrimaryVersionSpec version) {
        if (version == null) {
            return null;
        }
        for (HistoryInfo info : this.infos) {
            if (!version.equals(info.getPrimarySpec())) continue;
            return info;
        }
        return null;
    }

    private PrimaryVersionSpec biggestOrSmallesInfo(boolean biggest) {
        List input = (List)this.viewer.getInput();
        if (input == null) {
            return this.centerVersion;
        }
        ArrayList resultCandidates = new ArrayList(input);
        PrimaryVersionSpec result = this.centerVersion;
        for (HistoryInfo info : resultCandidates) {
            if (info.getPrimarySpec().getIdentifier() == -1 || (!biggest || info.getPrimarySpec().compareTo((Object)result) != 1) && (biggest || info.getPrimarySpec().compareTo((Object)result) != -1)) continue;
            result = info.getPrimarySpec();
        }
        return result;
    }

    private void addLinkWithNavigatorAction(IToolBarManager menuManager) {
        this.isUnlinkedFromNavigator = Activator.getDefault().getDialogSettings().getBoolean("LinkWithNavigator");
        Action linkWithNavigator = new Action("Link with navigator", 2){

            public void run() {
                Activator.getDefault().getDialogSettings().put("LinkWithNavigator", !this.isChecked());
                HistoryBrowserView.this.isUnlinkedFromNavigator = !this.isChecked();
            }
        };
        linkWithNavigator.setImageDescriptor(Activator.getImageDescriptor("icons/link_with_editor.gif"));
        linkWithNavigator.setToolTipText("Link with Navigator");
        linkWithNavigator.setChecked(!this.isUnlinkedFromNavigator);
        menuManager.add((IAction)linkWithNavigator);
    }

    private void addShowAllBranchesAction(IToolBarManager menuManager) {
        this.showAllBranches = new Action("", 2){

            public void run() {
                HistoryBrowserView.this.showAllVersions = this.isChecked();
                HistoryBrowserView.this.refresh();
            }
        };
        this.showAllBranches.setImageDescriptor(Activator.getImageDescriptor("icons/arrow_branch.png"));
        this.showAllBranches.setToolTipText("Show All Branches");
        this.showAllBranches.setChecked(true);
        menuManager.add((IAction)this.showAllBranches);
    }

    private void addJumpToRevisionAction(IToolBarManager menuManager) {
        Action jumpTo = new Action(){

            public void run() {
                PrimaryVersionSpec versionSpec;
                InputDialog inputDialog = new InputDialog(HistoryBrowserView.this.getSite().getShell(), "Go to revision", "Revision", "", null);
                if (inputDialog.open() == 0 && HistoryBrowserView.this.projectSpace != null && (versionSpec = HistoryBrowserView.this.resolveVersion(inputDialog.getValue())) != null) {
                    HistoryBrowserView.this.showAll(true);
                    HistoryBrowserView.this.centerVersion = versionSpec;
                    HistoryBrowserView.this.refresh();
                }
            }
        };
        jumpTo.setImageDescriptor(Activator.getImageDescriptor("/icons/magnifier.png"));
        jumpTo.setToolTipText("Go to revision...");
        menuManager.add((IAction)jumpTo);
    }

    private PrimaryVersionSpec resolveVersion(final String value) {
        return (PrimaryVersionSpec)new AbstractEMFStoreUIController<PrimaryVersionSpec>(this.getViewSite().getShell()){

            @Override
            public PrimaryVersionSpec doRun(IProgressMonitor monitor) throws ESException {
                return (PrimaryVersionSpec)new UnknownEMFStoreWorkloadCommand<PrimaryVersionSpec>(monitor){

                    public PrimaryVersionSpec run(IProgressMonitor monitor) throws ESException {
                        try {
                            return HistoryBrowserView.this.projectSpace.resolveVersionSpec((VersionSpec)Versions.createPRIMARY((String)"___GLOBAL___", (int)Integer.parseInt(value)), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (ESException e) {
                            EMFStoreMessageDialog.showExceptionDialog("Error: The version you requested does not exist.", (Exception)((Object)e));
                        }
                        catch (NumberFormatException numberFormatException) {
                            MessageDialog.openError((Shell)HistoryBrowserView.this.getSite().getShell(), (String)"Error", (String)"A numeric value was expected!");
                        }
                        return null;
                    }
                }.execute();
            }
        }.execute();
    }

    private void addExpandAllAndCollapseAllAction(IToolBarManager menuManager) {
        ImageDescriptor expandImg = Activator.getImageDescriptor("icons/expandall.gif");
        ImageDescriptor collapseImg = Activator.getImageDescriptor("icons/collapseall.gif");
        this.expandAndCollapse = new ExpandCollapseAction("", 2, expandImg, collapseImg);
        this.expandAndCollapse.setImageDescriptor(expandImg);
        this.expandAndCollapse.setToolTipText("Use this toggle to expand or collapse all elements");
        menuManager.add((IAction)this.expandAndCollapse);
    }

    private final class ExpandCollapseAction
    extends Action {
        private final ImageDescriptor expandImg;
        private final ImageDescriptor collapseImg;

        private ExpandCollapseAction(String text, int style, ImageDescriptor expandImg, ImageDescriptor collapseImg) {
            super(text, style);
            this.expandImg = expandImg;
            this.collapseImg = collapseImg;
        }

        public void run() {
            if (!this.isChecked()) {
                this.setImage(true);
                HistoryBrowserView.this.viewer.collapseAll();
            } else {
                this.setImage(false);
                HistoryBrowserView.this.viewer.expandToLevel(2);
            }
        }

        public void setImage(boolean expand) {
            this.setImageDescriptor(expand ? this.expandImg : this.collapseImg);
        }
    }

    private final class TreeViewerWithModelElementSelectionProvider
    extends TreeViewer {
        private TreeViewerWithModelElementSelectionProvider(Composite parent) {
            super(parent, 2);
        }

        protected Widget internalExpand(Object elementOrPath, boolean expand) {
            return super.internalExpand(elementOrPath, expand);
        }

        public ISelection getSelection() {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return super.getSelection();
            }
            Item[] items = this.getSelection(this.getControl());
            if (items.length != 1) {
                return super.getSelection();
            }
            Item item = items[0];
            Object data = item.getData();
            if (data == null) {
                return super.getSelection();
            }
            Object element = data;
            EObject selectedModelElement = null;
            if (element instanceof CompositeOperation) {
                selectedModelElement = this.handleCompositeOperation((CompositeOperation)element);
            } else if (element instanceof AbstractOperation) {
                selectedModelElement = this.handleAbstractOperation((AbstractOperation)element);
            } else if (element instanceof ProjectSpace) {
                selectedModelElement = ((ProjectSpace)element).getProject();
            } else if (element instanceof ModelElementId && HistoryBrowserView.this.projectSpace.getProject().contains((ModelElementId)element)) {
                selectedModelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement((ModelElementId)element);
            } else if (HistoryBrowserView.this.projectSpace.getProject().contains((EObject)element)) {
                selectedModelElement = (EObject)element;
            }
            if (selectedModelElement != null) {
                return new StructuredSelection((Object)selectedModelElement);
            }
            return super.getSelection();
        }

        private EObject handleCompositeOperation(CompositeOperation op) {
            AbstractOperation mainOperation = op.getMainOperation();
            if (mainOperation != null) {
                ModelElementId modelElementId = mainOperation.getModelElementId();
                EObject modelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement(modelElementId);
                return modelElement;
            }
            return null;
        }

        private EObject handleAbstractOperation(AbstractOperation op) {
            ModelElementId modelElementId = op.getModelElementId();
            EObject modelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement(modelElementId);
            return modelElement;
        }
    }
}

