/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.sessionprovider.ESServerCall;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerCallImpl;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCall<U>
implements APIDelegate<ESServerCall> {
    private ProjectSpace projectSpace;
    private Usersession usersession;
    private ServerInfo server;
    private SessionId sessionId;
    private IProgressMonitor monitor;
    private U ret;
    private ESServerCall apiImpl;

    public ServerCall() {
    }

    public ServerCall(Usersession usersession) {
        this.usersession = usersession;
        this.setProgressMonitor(null);
    }

    public ServerCall(ProjectSpace localProject) {
        this.projectSpace = localProject;
        this.setProgressMonitor(null);
    }

    public ServerCall(ServerInfo server) {
        this.server = server;
        this.setProgressMonitor(null);
    }

    public ServerCall(Usersession usersession, IProgressMonitor monitor) {
        this.usersession = usersession;
        this.setProgressMonitor(monitor);
    }

    public ServerCall(ProjectSpace localProject, IProgressMonitor monitor) {
        this.projectSpace = localProject;
        this.setProgressMonitor(monitor);
    }

    public ServerCall(ServerInfo server, IProgressMonitor monitor) {
        this.server = server;
        this.setProgressMonitor(monitor);
    }

    public ServerInfo getServer() {
        return this.server;
    }

    public ServerCall<U> setServer(ServerInfo server) {
        this.server = server;
        return this;
    }

    public ServerCall<U> setUsersession(Usersession usersession) {
        this.usersession = usersession;
        return this;
    }

    public Usersession getUsersession() {
        return this.usersession;
    }

    public ProjectSpaceBase getProjectSpace() {
        return (ProjectSpaceBase)this.projectSpace;
    }

    public ServerCall<U> setProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.monitor = monitor;
        return this;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected ConnectionManager getConnectionManager() {
        return ESWorkspaceProviderImpl.getInstance().getConnectionManager();
    }

    protected SessionId getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(SessionId sessionId) {
        this.sessionId = sessionId;
    }

    public void run(SessionId sessionId) throws ESException {
        this.setSessionId(sessionId);
        this.ret = this.run();
    }

    protected abstract U run() throws ESException;

    public U execute() throws ESException {
        ESWorkspaceProviderImpl.getInstance().getSessionManager().execute(this);
        return this.ret;
    }

    public ESServerCall toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESServerCall createAPI() {
        return new ESServerCallImpl(this);
    }
}

