/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESLogoutObserver;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersessionImpl
extends EObjectImpl
implements Usersession {
    private ESUsersessionImpl apiImpl;
    protected static final String USERNAME_EDEFAULT = null;
    protected String username = USERNAME_EDEFAULT;
    protected static final String PASSWORD_EDEFAULT = null;
    protected String password = PASSWORD_EDEFAULT;
    protected SessionId sessionId;
    protected static final String PERSISTENT_PASSWORD_EDEFAULT = null;
    protected String persistentPassword = PERSISTENT_PASSWORD_EDEFAULT;
    protected ServerInfo serverInfo;
    protected static final boolean SAVE_PASSWORD_EDEFAULT = false;
    protected boolean savePassword = false;
    protected ACUser acUser;
    protected EList<OrgUnitProperty> changedProperties;

    protected UsersessionImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.USERSESSION;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String newUsername) {
        String oldUsername = this.username;
        this.username = newUsername;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldUsername, (Object)this.username));
        }
    }

    public String getPasswordGen() {
        return this.password;
    }

    @Override
    public String getPassword() {
        if (this.isSavePassword()) {
            return this.getPersistentPassword();
        }
        return this.password;
    }

    public void setPasswordGen(String newPassword) {
        String oldPassword = this.password;
        this.password = newPassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldPassword, (Object)this.password));
        }
    }

    @Override
    public void setPassword(String newPassword) {
        if (newPassword != null) {
            this.setPasswordGen(KeyStoreManager.getInstance().encrypt(newPassword, this.getServerInfo()));
        } else {
            this.setPasswordGen(null);
        }
        if (this.isSavePassword() && !newPassword.equals(this.persistentPassword)) {
            this.setPersistentPassword(KeyStoreManager.getInstance().encrypt(newPassword, this.getServerInfo()));
        }
    }

    public SessionId getSessionIdGen() {
        if (this.sessionId != null && this.sessionId.eIsProxy()) {
            InternalEObject oldSessionId = (InternalEObject)this.sessionId;
            this.sessionId = (SessionId)this.eResolveProxy(oldSessionId);
            if (this.sessionId != oldSessionId && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldSessionId, (Object)this.sessionId));
            }
        }
        return this.sessionId;
    }

    public SessionId basicGetSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(SessionId newSessionId) {
        SessionId oldSessionId = this.sessionId;
        this.sessionId = newSessionId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSessionId, (Object)this.sessionId));
        }
    }

    @Override
    public String getPersistentPassword() {
        return this.persistentPassword;
    }

    public void setPersistentPasswordGen(String newPersistentPassword) {
        String oldPersistentPassword = this.persistentPassword;
        this.persistentPassword = newPersistentPassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPersistentPassword, (Object)this.persistentPassword));
        }
    }

    @Override
    public void setPersistentPassword(String newPersistentPassword) {
        this.setPersistentPasswordGen(newPersistentPassword);
    }

    @Override
    public ServerInfo getServerInfo() {
        if (this.serverInfo != null && this.serverInfo.eIsProxy()) {
            InternalEObject oldServerInfo = (InternalEObject)this.serverInfo;
            this.serverInfo = (ServerInfo)this.eResolveProxy(oldServerInfo);
            if (this.serverInfo != oldServerInfo && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldServerInfo, (Object)this.serverInfo));
            }
        }
        return this.serverInfo;
    }

    public ServerInfo basicGetServerInfo() {
        return this.serverInfo;
    }

    @Override
    public void setServerInfo(ServerInfo newServerInfo) {
        ServerInfo oldServerInfo = this.serverInfo;
        this.serverInfo = newServerInfo;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldServerInfo, (Object)this.serverInfo));
        }
    }

    @Override
    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePasswordGen(boolean newSavePassword) {
        boolean oldSavePassword = this.savePassword;
        this.savePassword = newSavePassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldSavePassword, this.savePassword));
        }
    }

    @Override
    public void setSavePassword(boolean newSavePassword) {
        if (!newSavePassword) {
            this.setPersistentPassword(null);
        } else if (this.getPasswordGen() != null) {
            this.setPersistentPassword(this.getPasswordGen());
        }
        this.setSavePasswordGen(newSavePassword);
    }

    @Override
    public ACUser getACUser() {
        if (this.acUser != null && this.acUser.eIsProxy()) {
            InternalEObject oldACUser = (InternalEObject)this.acUser;
            this.acUser = (ACUser)this.eResolveProxy(oldACUser);
            if (this.acUser != oldACUser) {
                InternalEObject newACUser = (InternalEObject)this.acUser;
                NotificationChain msgs = oldACUser.eInverseRemove((InternalEObject)this, -7, null, null);
                if (newACUser.eInternalContainer() == null) {
                    msgs = newACUser.eInverseAdd((InternalEObject)this, -7, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldACUser, (Object)this.acUser));
                }
            }
        }
        return this.acUser;
    }

    public ACUser basicGetACUser() {
        return this.acUser;
    }

    public NotificationChain basicSetACUser(ACUser newACUser, NotificationChain msgs) {
        ACUser oldACUser = this.acUser;
        this.acUser = newACUser;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldACUser, (Object)newACUser);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setACUser(ACUser newACUser) {
        if (newACUser != this.acUser) {
            NotificationChain msgs = null;
            if (this.acUser != null) {
                msgs = ((InternalEObject)this.acUser).eInverseRemove((InternalEObject)this, -7, null, msgs);
            }
            if (newACUser != null) {
                msgs = ((InternalEObject)newACUser).eInverseAdd((InternalEObject)this, -7, null, msgs);
            }
            if ((msgs = this.basicSetACUser(newACUser, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newACUser, (Object)newACUser));
        }
    }

    @Override
    public EList<OrgUnitProperty> getChangedProperties() {
        if (this.changedProperties == null) {
            this.changedProperties = new EObjectContainmentEList.Resolving(OrgUnitProperty.class, (InternalEObject)this, 7);
        }
        return this.changedProperties;
    }

    @Override
    public boolean isLoggedIn() {
        return this.sessionId != null;
    }

    @Override
    public void logIn() throws ESException, AccessControlException {
        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        if (this.getUsername() == null || this.getPassword() == null) {
            throw new AccessControlException("Username or Password not set!");
        }
        ServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            throw new IllegalStateException("No ServerInfo set!");
        }
        if (serverInfo.getUrl() == null) {
            throw new ConnectionException("Invalid server url: null");
        }
        ServerInfo copy = (ServerInfo)ModelUtil.clone((EObject)serverInfo);
        copy.setLastUsersession(null);
        AuthenticationInformation authenticationInformation = connectionManager.logIn(this.username, this.getPassword(), copy, Configuration.getVersioningInfo().getClientVersion());
        this.getServerInfo().setLastUsersession(this);
        this.setSessionId(authenticationInformation.getSessionId());
        this.setACUser(authenticationInformation.getResolvedACUser());
        ((ESLoginObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESLoginObserver.class)).loginCompleted(this.toAPI());
    }

    @Override
    public void logout() throws ESException {
        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        connectionManager.logout(this.sessionId);
        this.setSessionId(null);
        ((ESLogoutObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESLogoutObserver.class)).logoutCompleted(this.toAPI());
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return this.basicSetACUser(null, msgs);
            }
            case 7: {
                return ((InternalEList)this.getChangedProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getUsername();
            }
            case 1: {
                return this.getPassword();
            }
            case 2: {
                if (resolve) {
                    return this.getSessionId();
                }
                return this.basicGetSessionId();
            }
            case 3: {
                return this.getPersistentPassword();
            }
            case 4: {
                if (resolve) {
                    return this.getServerInfo();
                }
                return this.basicGetServerInfo();
            }
            case 5: {
                return this.isSavePassword();
            }
            case 6: {
                if (resolve) {
                    return this.getACUser();
                }
                return this.basicGetACUser();
            }
            case 7: {
                return this.getChangedProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setUsername((String)newValue);
                return;
            }
            case 1: {
                this.setPassword((String)newValue);
                return;
            }
            case 2: {
                this.setSessionId((SessionId)newValue);
                return;
            }
            case 3: {
                this.setPersistentPassword((String)newValue);
                return;
            }
            case 4: {
                this.setServerInfo((ServerInfo)newValue);
                return;
            }
            case 5: {
                this.setSavePassword((Boolean)newValue);
                return;
            }
            case 6: {
                this.setACUser((ACUser)newValue);
                return;
            }
            case 7: {
                this.getChangedProperties().clear();
                this.getChangedProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setUsername(USERNAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 2: {
                this.setSessionId(null);
                return;
            }
            case 3: {
                this.setPersistentPassword(PERSISTENT_PASSWORD_EDEFAULT);
                return;
            }
            case 4: {
                this.setServerInfo(null);
                return;
            }
            case 5: {
                this.setSavePassword(false);
                return;
            }
            case 6: {
                this.setACUser(null);
                return;
            }
            case 7: {
                this.getChangedProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return USERNAME_EDEFAULT == null ? this.username != null : !USERNAME_EDEFAULT.equals(this.username);
            }
            case 1: {
                return PASSWORD_EDEFAULT == null ? this.password != null : !PASSWORD_EDEFAULT.equals(this.password);
            }
            case 2: {
                return this.sessionId != null;
            }
            case 3: {
                return PERSISTENT_PASSWORD_EDEFAULT == null ? this.persistentPassword != null : !PERSISTENT_PASSWORD_EDEFAULT.equals(this.persistentPassword);
            }
            case 4: {
                return this.serverInfo != null;
            }
            case 5: {
                return this.savePassword;
            }
            case 6: {
                return this.acUser != null;
            }
            case 7: {
                return this.changedProperties != null && !this.changedProperties.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (username: ");
        result.append(this.username);
        result.append(')');
        return result.toString();
    }

    @Override
    public SessionId getSessionId() {
        return this.getSessionIdGen();
    }

    public ESUsersessionImpl toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESUsersessionImpl createAPI() {
        return new ESUsersessionImpl(this);
    }
}

