/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConflict
extends VisualConflict {
    public CompositeConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean meCausing) {
        super(conflictBucket, decisionManager, meCausing, false);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getLeftOperation(), this.getTheirOperation());
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (OperationUtil.isComposite((AbstractOperation)this.getMyOperation()) && OperationUtil.isComposite((AbstractOperation)this.getTheirOperation())) {
            description.setDescription(DecisionUtil.getDescription("compositeconflict.both", this.getDecisionManager().isBranchMerge()));
            description.add("localcompdescription", this.getLeftOperation());
            description.add("incomingcompdescription", this.getRightOperation());
        } else if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription("compositeconflict.my", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("compositeconflict.their", this.getDecisionManager().isBranchMerge()));
        }
        description.add("compdescription", this.getLeftOperation());
        description.add("opposite", this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        description.setImage("composite.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        String composite = ((CompositeOperation)this.getLeftOperation()).getCompositeName();
        String other = null;
        other = this.getRightOperation() instanceof CompositeOperation ? ((CompositeOperation)this.getRightOperation()).getCompositeName() : "Change related to " + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        if (this.isLeftMy()) {
            myOption.setOptionLabel(composite);
            theirOption.setOptionLabel(other);
        } else {
            myOption.setOptionLabel(other);
            theirOption.setOptionLabel(composite);
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

