/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumMap;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.MethodInvocation;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EMFStorePropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EPackageSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.FileTransferSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.HistorySubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectPropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.UserSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class EMFStoreImpl
extends AbstractEmfstoreInterface
implements InvocationHandler {
    private EnumMap<EmfStoreMethod.MethodId, SubInterfaceMethod> subInterfaceMethods;

    public EMFStoreImpl(ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalESException {
        super(serverSpace, authorizationControl);
    }

    protected void initSubInterfaces() throws FatalESException {
        this.subInterfaceMethods = new EnumMap(EmfStoreMethod.MethodId.class);
        this.addSubInterface(new HistorySubInterfaceImpl(this));
        this.addSubInterface(new ProjectSubInterfaceImpl(this));
        this.addSubInterface(new UserSubInterfaceImpl(this));
        this.addSubInterface(new VersionSubInterfaceImpl(this));
        this.addSubInterface(new FileTransferSubInterfaceImpl(this));
        this.addSubInterface(new ProjectPropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EMFStorePropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EPackageSubInterfaceImpl(this));
    }

    protected void addSubInterface(AbstractSubEmfstoreInterface iface) {
        super.addSubInterface(iface);
        Method[] methodArray = iface.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            EmfStoreMethod implSpec = method.getAnnotation(EmfStoreMethod.class);
            if (implSpec != null) {
                this.subInterfaceMethods.put(implSpec.value(), new SubInterfaceMethod(iface, method));
            }
            ++n2;
        }
    }

    public Object invoke(Object obj, Method method, Object[] args) throws ESException {
        MethodInvocation methodInvocation = new MethodInvocation(method.getName(), args);
        this.getAuthorizationControl().checkAccess(methodInvocation);
        SubInterfaceMethod subIfaceMethod = this.subInterfaceMethods.get((Object)methodInvocation.getType());
        return subIfaceMethod.getIface().execute(subIfaceMethod.getMethod(), args);
    }

    public static EMFStore createInterface(ServerSpace serverSpace, AuthorizationControl accessControl) throws IllegalArgumentException, FatalESException {
        return (EMFStore)Proxy.newProxyInstance(EMFStoreImpl.class.getClassLoader(), new Class[]{EMFStore.class}, (InvocationHandler)new EMFStoreImpl(serverSpace, accessControl));
    }

    private class SubInterfaceMethod {
        private AbstractSubEmfstoreInterface iface;
        private Method method;

        public SubInterfaceMethod(AbstractSubEmfstoreInterface iface, Method m) {
            this.method = m;
            this.iface = iface;
        }

        public AbstractSubEmfstoreInterface getIface() {
            return this.iface;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

