/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.LinkedHashMapWithConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.OppositeReservationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureNameReservationMap
extends LinkedHashMapWithConflictBucketCandidate<OppositeReservationMap> {
    private static final long serialVersionUID = -908068067539831820L;
    public static final String EXISTENCE_FEATURE = "+existence";
    public static final String CONTAINER_FEATURE = "+container";
    private boolean isAllFeatures;

    public FeatureNameReservationMap(boolean isAllFeatures) {
        this.isAllFeatures = isAllFeatures;
    }

    public FeatureNameReservationMap() {
        this(false);
    }

    @Override
    public Set<ConflictBucketCandidate> getAllConflictBucketCandidates() {
        LinkedHashSet<ConflictBucketCandidate> result = new LinkedHashSet<ConflictBucketCandidate>();
        if (this.isAllFeatures) {
            if (this.getConflictBucketCandidate() != null) {
                result.add(this.getConflictBucketCandidate());
            }
            return result;
        }
        for (String featureName : this.keySet()) {
            result.addAll(((OppositeReservationMap)this.get(featureName)).getAllConflictBucketCandidates());
        }
        return result;
    }

    public boolean hasExistenceFeature() {
        return this.containsKey(EXISTENCE_FEATURE);
    }

    public boolean isAllFeatures() {
        return this.isAllFeatures;
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String featureName) {
        LinkedHashSet<ConflictBucketCandidate> result = new LinkedHashSet<ConflictBucketCandidate>();
        if (this.isAllFeatures()) {
            result.add(this.getConflictBucketCandidate());
            return result;
        }
        OppositeReservationMap oppositeReservationMap = (OppositeReservationMap)this.get(featureName);
        if (oppositeReservationMap == null) {
            return result;
        }
        return oppositeReservationMap.getAllConflictBucketCandidates();
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String featureName, String oppositeModelElement) {
        LinkedHashSet<ConflictBucketCandidate> result = new LinkedHashSet<ConflictBucketCandidate>();
        if (this.isAllFeatures()) {
            result.add(this.getConflictBucketCandidate());
            return result;
        }
        OppositeReservationMap oppositeReservationMap = (OppositeReservationMap)this.get(featureName);
        if (oppositeReservationMap == null) {
            return result;
        }
        return oppositeReservationMap.getConflictBucketCandidates(oppositeModelElement);
    }
}

