/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;

public class SimplePropertyFileVerifier
extends AbstractAuthenticationControl {
    private Properties passwordFile;
    private final Hash hash;

    public SimplePropertyFileVerifier(String filePath) throws FatalESException {
        this(filePath, Hash.NONE);
    }

    public SimplePropertyFileVerifier(String filePath, Hash hash) throws FatalESException {
        block15: {
            if (hash == null) {
                throw new FatalESException("Hash may not be null for verifier.");
            }
            this.hash = hash;
            this.passwordFile = new Properties();
            File propertyFile = new File(filePath);
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(propertyFile);
                    this.passwordFile.load(fis);
                }
                catch (IOException iOException) {
                    ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException2) {
                            ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                }
            }
        }
    }

    protected boolean verifyPassword(String username, String password) throws AccessControlException {
        String expectedPassword = this.passwordFile.getProperty(username);
        password = this.hashPassword(password);
        return expectedPassword != null && expectedPassword.equals(password);
    }

    private String hashPassword(String password) {
        if (password == null || this.hash.equals((Object)Hash.NONE)) {
            return password;
        }
        try {
            MessageDigest md = null;
            switch (this.hash) {
                case SHA1: {
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                case MD5: {
                    md = MessageDigest.getInstance("MD5");
                }
            }
            if (md != null) {
                return new String(md.digest(password.getBytes()));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hash {
        NONE,
        MD5,
        SHA1;

    }
}

