/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.testers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.emfstore.internal.client.accesscontrol.AccessControlHelper;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;

public class IsServerAdminTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, final Object expectedValue) {
        if ((receiver instanceof ServerInfo || receiver instanceof ProjectInfo) && expectedValue instanceof Boolean) {
            ServerInfo serverInfo = null;
            if (receiver instanceof ServerInfo) {
                serverInfo = (ServerInfo)receiver;
            } else if (receiver instanceof ProjectInfo) {
                ProjectInfo projectInfo = (ProjectInfo)receiver;
                serverInfo = this.findServerInfo(projectInfo);
            }
            if (serverInfo == null) {
                return false;
            }
            final ServerInfo finalServerInfo = serverInfo;
            EMFStoreCommandWithResult<Boolean> command = new EMFStoreCommandWithResult<Boolean>(){

                protected Boolean doRun() {
                    Usersession usersession = finalServerInfo.getLastUsersession();
                    boolean isAdmin = false;
                    if (usersession != null && usersession.getACUser() != null) {
                        AccessControlHelper accessControlHelper = new AccessControlHelper(usersession);
                        try {
                            accessControlHelper.checkServerAdminAccess();
                            isAdmin = true;
                        }
                        catch (AccessControlException accessControlException) {}
                    }
                    return new Boolean(isAdmin).equals(expectedValue);
                }
            };
            Boolean result = (Boolean)command.run(false);
            return result;
        }
        return true;
    }

    private ServerInfo findServerInfo(ProjectInfo projectInfo) {
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        for (ServerInfo serverInfo : ((Workspace)workspace.toInternalAPI()).getServerInfos()) {
            if (projectInfo.eContainer() == null || !projectInfo.eContainer().equals(serverInfo)) continue;
            return serverInfo;
        }
        return null;
    }
}

