/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="merge", label="Merge Reference into Another", description="In the metamodel, a reference is deleted. In the model, the values of this reference are merged to a compatible reference.")
public class Merge
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference that is deleted")
    public EReference toMerge;
    @EdaptParameter(description="The reference to which the values are merged")
    public EReference mergeTo;

    @EdaptConstraint(restricts="mergeTo", description="The references must be different from each other")
    public boolean checkReferencesDifferent(EReference mergeTo) {
        return this.toMerge != mergeTo;
    }

    @EdaptConstraint(description="The types of the references must be compatible")
    public boolean checkReferenceTypesCompatible() {
        return this.mergeTo.getEReferenceType().isSuperTypeOf(this.toMerge.getEReferenceType());
    }

    @EdaptConstraint(restricts="mergeTo", description="The reference to merge to must be multi-valued")
    public boolean checkMergeToMany(EReference mergeTo) {
        return mergeTo.isMany();
    }

    @EdaptConstraint(description="The reference to merge to must be available in the context class")
    public boolean checkMergeToAvailableInContextClass() {
        EClass contextClass = this.toMerge.getEContainingClass();
        return contextClass.getEAllStructuralFeatures().contains((Object)this.mergeTo);
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.toMerge.getEContainingClass();
        for (Instance instance : model.getAllInstances(contextClass)) {
            Object toMergeValue = instance.unset((EStructuralFeature)this.toMerge);
            List mergeToValue = (List)instance.get((EStructuralFeature)this.mergeTo);
            if (this.toMerge.isMany()) {
                mergeToValue.addAll((List)toMergeValue);
                continue;
            }
            mergeToValue.add(toMergeValue);
        }
        metamodel.delete((EModelElement)this.toMerge);
        if (this.toMerge.getEOpposite() != null) {
            metamodel.delete((EModelElement)this.toMerge.getEOpposite());
        }
    }
}

