/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.swt.internal.layout;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.layout.AbstractLayoutProvider;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ECPLayoutProvider
extends AbstractLayoutProvider {
    public Layout getColumnLayout(int numColumns, boolean equalWidth) {
        return GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(equalWidth).create();
    }

    public Object getLayoutData(SWTGridCell gridCell, SWTGridDescription controlGridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, EObject domainModel, Control control) {
        if (VControl.class.isInstance(vElement)) {
            if (gridCell.getColumn() + gridCell.getHorizontalSpan() == controlGridDescription.getColumns()) {
                return this.getControlGridData(gridCell.getHorizontalSpan() + fullGridDescription.getColumns() - currentRowGridDescription.getColumns(), (VControl)VControl.class.cast(vElement), domainModel, control);
            }
            if (controlGridDescription.getColumns() == 3 && gridCell.getColumn() == 0) {
                return this.getLabelGridData();
            }
            if (controlGridDescription.getColumns() == 3 && gridCell.getColumn() == 1) {
                return this.getValidationGridData();
            }
            if (controlGridDescription.getColumns() == 2 && gridCell.getColumn() == 0) {
                return this.getValidationGridData();
            }
        }
        return GridDataFactory.fillDefaults().align(gridCell.isHorizontalFill() ? 4 : 1, gridCell.isVerticalFill() ? 4 : 0x1000000).grab(gridCell.isHorizontalGrab(), gridCell.isVerticalGrab()).span(gridCell.getHorizontalSpan() + fullGridDescription.getColumns() - currentRowGridDescription.getColumns(), 1).create();
    }

    private GridData getLabelGridData() {
        return GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).create();
    }

    private GridData getValidationGridData() {
        return GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(16, 17).grab(false, false).create();
    }

    private GridData getControlGridData(int xSpan, VControl vControl, EObject domainModel, Control control) {
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(xSpan, 1);
        if (Text.class.isInstance(control) && vControl.getDomainModelReference() != null && ECPLayoutProvider.isMultiLine((VDomainModelReference)vControl.getDomainModelReference(), (EObject)domainModel)) {
            gdf = gdf.hint(50, 200);
        }
        return gdf.create();
    }

    private GridData getSpanningGridData(int xSpan, int ySpan) {
        return GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(xSpan, ySpan).create();
    }

    public Object getSpanningLayoutData(int spanX, int spanY) {
        return this.getSpanningGridData(spanX, spanY);
    }
}

