/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateDomainModelReferenceWizard;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class TableColumnsDMRTableControl
extends SimpleControlSWTRenderer {
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryLabelProvider labelProvider;
    private AdapterImpl adapter;
    private VTableControl tableControl;
    private EStructuralFeature.Setting setting;

    protected Control createControl(Composite parent) {
        this.setting = (EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next();
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(titleComposite);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)titleComposite);
        Label filler = new Label(titleComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)filler);
        Composite buttonComposite = new Composite(titleComposite, 0);
        buttonComposite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(false, false).applyTo((Control)buttonComposite);
        Button buttonSort = new Button(buttonComposite, 8);
        buttonSort.setText("Sort");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)buttonSort);
        Button buttonAdd = new Button(buttonComposite, 8);
        buttonAdd.setText("Add");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)buttonAdd);
        Button buttonRemove = new Button(buttonComposite, 8);
        buttonRemove.setText("Remove");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)buttonRemove);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setBackgroundMode(2);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(1, 100).applyTo((Control)tableComposite);
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(tableComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(viewer.getControl());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        IItemPropertyDescriptor propertyDescriptor = this.getItemPropertyDescriptor(this.setting);
        column.getColumn().setText(propertyDescriptor.getDisplayName(null));
        column.getColumn().setToolTipText(propertyDescriptor.getDescription(null));
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, true));
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.addDragAndDropSupport(viewer, this.getEditingDomain(this.setting));
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(this.setting), (EObject)this.setting.getEObject(), (EStructuralFeature)this.setting.getEStructuralFeature());
        viewer.setInput((Object)list);
        this.tableControl = (VTableControl)this.getViewModelContext().getDomainModel();
        this.adapter = new TableControlAdapter(parent, viewer);
        this.tableControl.eAdapters().add((Object)this.adapter);
        buttonSort.addSelectionListener((SelectionListener)new SortSelectionAdapter());
        buttonAdd.addSelectionListener((SelectionListener)new AddSelectionAdapter(tableComposite, viewer));
        buttonRemove.addSelectionListener((SelectionListener)new RemoveSelectionAdapter(viewer));
        return composite;
    }

    private void addDragAndDropSupport(TableViewer viewer, EditingDomain editingDomain) {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter(editingDomain, (Viewer)viewer);
        viewer.addDropSupport(2, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
    }

    protected void postInit() {
        super.postInit();
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    }

    protected void dispose() {
        this.labelProvider.dispose();
        this.composedAdapterFactory.dispose();
        this.tableControl.eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    protected String getUnsetText() {
        return "No columns set";
    }

    private final class AddSelectionAdapter
    extends SelectionAdapter {
        private final Composite tableComposite;
        private final TableViewer viewer;

        private AddSelectionAdapter(Composite tableComposite, TableViewer viewer) {
            this.tableComposite = tableComposite;
            this.viewer = viewer;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)VTableDomainModelReference.class.cast(TableColumnsDMRTableControl.this.setting.getEObject());
            EClass eclass = ((EReference)EReference.class.cast(tableDomainModelReference.getEStructuralFeatureIterator().next())).getEReferenceType();
            Collection classes = ECPUtil.getSubClasses((EClass)VViewPackage.eINSTANCE.getDomainModelReference());
            CreateDomainModelReferenceWizard wizard = new CreateDomainModelReferenceWizard(TableColumnsDMRTableControl.this.setting, TableColumnsDMRTableControl.this.getEditingDomain(TableColumnsDMRTableControl.this.setting), eclass, "New Reference Element", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement, (VDomainModelReference)((IStructuredSelection)IStructuredSelection.class.cast(this.viewer.getSelection())).getFirstElement());
            SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
            wizard.setCompositeProvider((CompositeProvider)helper);
            WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wd.open();
            this.tableComposite.layout();
        }
    }

    private final class RemoveSelectionAdapter
    extends SelectionAdapter {
        private final TableViewer viewer;

        private RemoveSelectionAdapter(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            IStructuredSelection selection = (IStructuredSelection)IStructuredSelection.class.cast(this.viewer.getSelection());
            EditingDomain editingDomain = TableColumnsDMRTableControl.this.getEditingDomain(TableColumnsDMRTableControl.this.setting);
            editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)TableColumnsDMRTableControl.this.setting.getEObject(), (Object)TableColumnsDMRTableControl.this.setting.getEStructuralFeature(), (Collection)selection.toList()));
        }
    }

    private final class SortSelectionAdapter
    extends SelectionAdapter {
        private boolean down;

        private SortSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            this.down = !this.down;
            ArrayList list = new ArrayList((List)TableColumnsDMRTableControl.this.setting.get(true));
            Collections.sort(list, new Comparator<VDomainModelReference>(){

                @Override
                public int compare(VDomainModelReference o1, VDomainModelReference o2) {
                    String label1 = TableColumnsDMRTableControl.this.labelProvider.getText((Object)o1);
                    String label2 = TableColumnsDMRTableControl.this.labelProvider.getText((Object)o2);
                    int result = label1.compareTo(label2);
                    if (!SortSelectionAdapter.this.down) {
                        result *= -1;
                    }
                    return result;
                }
            });
            EditingDomain editingDomain = TableColumnsDMRTableControl.this.getEditingDomain(TableColumnsDMRTableControl.this.setting);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)TableColumnsDMRTableControl.this.setting.getEObject(), (Object)TableColumnsDMRTableControl.this.setting.getEStructuralFeature(), list));
        }
    }

    private final class TableControlAdapter
    extends AdapterImpl {
        private final Composite parent;
        private final TableViewer viewer;

        private TableControlAdapter(Composite parent, TableViewer viewer) {
            this.parent = parent;
            this.viewer = viewer;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getFeature() == VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences()) {
                this.viewer.refresh();
                this.parent.layout();
            }
            if (VTableDomainModelReference.class.isInstance(notification.getNotifier())) {
                this.updateSetting();
                this.viewer.refresh();
                this.parent.layout();
            }
            if (VTableControl.class.isInstance(notification.getNotifier()) && (VTableDomainModelReference.class.isInstance(notification.getNewValue()) || VTableDomainModelReference.class.isInstance(notification.getOldValue()))) {
                this.updateSetting();
                this.viewer.refresh();
                this.parent.layout();
            }
        }

        private void updateSetting() {
            Iterator iterator = ((VControl)TableColumnsDMRTableControl.this.getVElement()).getDomainModelReference().getIterator();
            if (iterator.hasNext()) {
                TableColumnsDMRTableControl.this.setting = (EStructuralFeature.Setting)iterator.next();
                IObservableList list = EMFEditObservables.observeList((EditingDomain)TableColumnsDMRTableControl.this.getEditingDomain(TableColumnsDMRTableControl.this.setting), (EObject)TableColumnsDMRTableControl.this.setting.getEObject(), (EStructuralFeature)TableColumnsDMRTableControl.this.setting.getEStructuralFeature());
                this.viewer.setInput((Object)list);
            } else {
                this.viewer.setInput((Object)Observables.emptyObservableList());
            }
        }
    }
}

