/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfcloud.jackson.annotations.EcoreReferenceInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreTypeInfo;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.utils.EObjects;

public class EcoreReferenceDeserializer
extends JsonDeserializer<ReferenceEntry> {
    private final EcoreReferenceInfo info;
    private final EcoreTypeInfo typeInfo;

    public EcoreReferenceDeserializer(EcoreReferenceInfo info, EcoreTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
        this.info = info;
    }

    public ReferenceEntry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        EObject parent = EMFContext.getParent((DatabindContext)ctxt);
        EReference reference = EMFContext.getReference((DatabindContext)ctxt);
        String id = null;
        String type = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String field = jp.getCurrentName();
            if (field.equalsIgnoreCase(this.info.getProperty())) {
                id = jp.nextTextValue();
                continue;
            }
            if (!field.equalsIgnoreCase(this.typeInfo.getProperty())) continue;
            type = jp.nextTextValue();
        }
        if (id != null) {
            return EObjects.isFeatureMapEntry((EStructuralFeature)reference) ? new ReferenceEntry.ForMapEntry(parent, reference, id, type) : new ReferenceEntry.Base(parent, reference, id, type);
        }
        return null;
    }
}

