/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.additional.builder.builder;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.parsley.dsl.pluginxml.PluginXmlLoader;
import org.eclipse.xtext.util.StringInputStream;

public class EmfParsleyDslPluginXmlBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.emf.parsley.dsl.additional.builder.emfParsleyDslPluginXmlBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta == null) {
            this.fullBuild(monitor);
        } else {
            this.incrementalBuild(delta, monitor);
        }
        return null;
    }

    void copyFromGeneratedPluginXml(IResource resource) throws CoreException {
        if (resource instanceof IFile && resource.getName().endsWith("xml_emfparsley_gen")) {
            IFile file = (IFile)resource;
            IFile pluginXml = this.getProject().getFile("/plugin.xml");
            PluginXmlLoader pluginXmlLoader = null;
            if (!pluginXml.exists()) {
                pluginXmlLoader = new PluginXmlLoader("");
                pluginXmlLoader.copyFromPluginXml(this.loadFromResource(file));
                pluginXml.create((InputStream)new StringInputStream(pluginXmlLoader.getContentsAsString()), true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                pluginXmlLoader = new PluginXmlLoader(this.loadFromResource(pluginXml));
                pluginXmlLoader.load();
                pluginXmlLoader.copyFromPluginXml(this.loadFromResource(file));
                pluginXml.setContents((InputStream)new StringInputStream(pluginXmlLoader.getContentsAsString()), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected String loadFromResource(IFile file) throws CoreException {
        return this.loadFromResource(new UtilityIFileReader(file), file.getFullPath().toString());
    }

    protected String loadFromResource(UtilityIFileReader iFileReader, String information) throws CoreException {
        try {
            return iFileReader.readFromResource();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.parsley.dsl.additional.builder", "while reading " + information, (Throwable)e));
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new EmfParsleyDslPluginXmlBuilderResourceVisitor());
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new EmfParsleyDslPluginXmlBuilderDeltaVisitor());
    }

    class EmfParsleyDslPluginXmlBuilderDeltaVisitor
    implements IResourceDeltaVisitor {
        EmfParsleyDslPluginXmlBuilderDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (delta.getKind() != 2) {
                EmfParsleyDslPluginXmlBuilder.this.copyFromGeneratedPluginXml(resource);
            }
            return true;
        }
    }

    class EmfParsleyDslPluginXmlBuilderResourceVisitor
    implements IResourceVisitor {
        EmfParsleyDslPluginXmlBuilderResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            EmfParsleyDslPluginXmlBuilder.this.copyFromGeneratedPluginXml(resource);
            return true;
        }
    }

    public static class UtilityIFileReader {
        private IFile file;

        public UtilityIFileReader(IFile file) {
            this.file = file;
        }

        public String readFromResource() throws IOException, CoreException {
            InputStreamReader reader = new InputStreamReader(this.file.getContents());
            String string = CharStreams.toString((Readable)reader);
            reader.close();
            return string;
        }
    }
}

