/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.core.preferences;

import java.io.File;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.preferences.Discoverer;
import org.eclipse.embedcdt.internal.managedbuild.cross.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;

public class DefaultPreferences
extends org.eclipse.embedcdt.core.preferences.DefaultPreferences {
    private static final String REG_SUBKEY = "\\GNU MCU Eclipse\\Build Tools";
    private static final String REG_SUBKEY_DEPRECATED = "\\GNU ARM Eclipse\\Build Tools";
    private static final String REG_NAME = "InstallLocation";

    public DefaultPreferences(String pluginId) {
        super(pluginId);
    }

    public String getToolchainName() {
        String key = "toolchain.name";
        String value = this.getString(key, null);
        if (value == null) {
            value = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainName() = \"" + value + "\"");
        }
        return value;
    }

    public void putToolchainName(String value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainName(\"" + value + "\")");
        }
        String key = "toolchain.name";
        this.putString(key, value);
    }

    public String getToolchainId() {
        String key = "toolchain.id";
        String value = this.getString(key, null);
        if (value == null) {
            value = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainId() = \"" + value + "\"");
        }
        return value;
    }

    public void putToolchainId(String value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainId(\"" + value + "\")");
        }
        String key = "toolchain.id";
        this.putString(key, value);
    }

    @Deprecated
    public String getToolchainPath(String toolchainName) {
        String key = PersistentPreferences.getToolchainKey(toolchainName);
        String value = this.getString(key, null);
        if (value == null) {
            value = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainPath(\"" + toolchainName + "\") = \"" + value + "\")");
        }
        return value;
    }

    public String getToolchainPath(String toolchainId, String toolchainName) {
        String key = PersistentPreferences.getToolchainKey(toolchainId, toolchainName);
        String value = this.getString(key, null);
        if (value == null) {
            value = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainPath(\"" + toolchainId + ", " + toolchainName + "\") = \"" + value + "\")");
        }
        return value;
    }

    @Deprecated
    public void putToolchainPath(String toolchainName, String value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainPath(\"" + toolchainName + "\", \"" + value + "\")");
        }
        String key = PersistentPreferences.getToolchainKey(toolchainName);
        this.putString(key, value);
    }

    public void putToolchainPath(String toolchainId, String toolchainName, String value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainPath(\"" + toolchainId + ", " + toolchainName + "\", \"" + value + "\")");
        }
        String key = PersistentPreferences.getToolchainKey(toolchainId, toolchainName);
        this.putString(key, value);
    }

    @Deprecated
    public String getToolchainSearchPath(String toolchainName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainSearchPath(\"" + toolchainName + "\")");
        }
        String key = PersistentPreferences.getToolchainSearchKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainSearchPath(\"" + toolchainName + "\") (" + key + ")");
        }
        String value = this.getString(key, "");
        return value;
    }

    public String getToolchainSearchPath(String toolchainId, String toolchainName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainSearchPath(\"" + toolchainId + ", " + toolchainName + "\")");
        }
        String key = PersistentPreferences.getToolchainSearchKey(toolchainId, toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainSearchPath(\"" + toolchainId + ", " + toolchainName + "\") (" + key + ")");
        }
        String value = this.getString(key, "");
        return value;
    }

    @Deprecated
    public void putToolchainSearchPath(String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainSearchKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainSearchPath(\"" + toolchainName + "\", \"" + value + "\") (" + key + ")");
        }
        this.putString(key, value);
    }

    public void putToolchainSearchPath(String toolchainId, String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainSearchKey(toolchainId, toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putToolchainSearchPath(\"" + toolchainId + ", " + toolchainName + "\", \"" + value + "\") (" + key + ")");
        }
        this.putString(key, value);
    }

    @Deprecated
    public String getToolchainSearchPathOs(String toolchainName) {
        String value = this.getString(PersistentPreferences.getToolchainSearchOsKey(toolchainName), "");
        return value;
    }

    public String getToolchainSearchPathOs(String toolchainId, String toolchainName) {
        String value = this.getString(PersistentPreferences.getToolchainSearchOsKey(toolchainId, toolchainName), "");
        return value;
    }

    @Deprecated
    public String[] getToolchainXpackNames(String toolchainName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainXpackName(\"" + toolchainName + "\")");
        }
        String key = PersistentPreferences.getToolchainXpackKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainXpackName(\"" + toolchainName + "\") (" + key + ")");
        }
        String[] values = this.getStringArray(key, "");
        return values;
    }

    public String[] getToolchainXpackNames(String toolchainId, String toolchainName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainXpackName(\"" + toolchainId + ", " + toolchainName + "\")");
        }
        String key = PersistentPreferences.getToolchainXpackKey(toolchainId, toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getToolchainXpackName(\"" + toolchainId + ", " + toolchainName + "\") (" + key + ")");
        }
        String[] values = this.getStringArray(key, "");
        return values;
    }

    public String getBuildToolsPath() {
        return this.getString("buildTools.path", "");
    }

    public void putBuildToolsPath(String value) {
        String key = "buildTools.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putBuildToolsPath(\"" + value + "\") (" + key + ")");
        }
        this.putString(key, value);
    }

    public String getBuildToolsSearchPath() {
        String key = "buildTools.search.path";
        return this.getString(key, "");
    }

    public String getBuildToolsSearchPathOs() {
        String os = EclipseUtils.getOsFamily();
        String key = String.format("buildTools.search.path.%s", os);
        return this.getString(key, "");
    }

    public void putBuildToolsSearchPath(String value) {
        String key = "buildTools.search.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putBuildToolsSearchPath(\"" + value + "\") (" + key + ")");
        }
        this.putString(key, value);
    }

    public String[] getBuildToolsXpackNames() {
        String key = "buildTools.xpack.names";
        CharSequence[] values = this.getStringArray(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getBuildToolsXpackNames() = \"" + String.join((CharSequence)";", values) + "\"");
        }
        return values;
    }

    public String discoverBuildToolsPath() {
        String exe;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverBuildToolsPath()");
        }
        String path = null;
        String executableName = "make";
        String subPath = "bin";
        if (EclipseUtils.isWindows() && (path = Discoverer.getRegistryInstallFolder((String)(exe = this.addExeExtension(executableName)), (String)subPath, (String)REG_SUBKEY, (String)REG_NAME)) == null) {
            path = Discoverer.getRegistryInstallFolder((String)exe, (String)subPath, (String)REG_SUBKEY_DEPRECATED, (String)REG_NAME);
        }
        String searchPath = null;
        if (path == null && (searchPath = this.getBuildToolsSearchPath()).isEmpty() && !(searchPath = this.getBuildToolsSearchPathOs()).isEmpty()) {
            this.putBuildToolsSearchPath(searchPath);
        }
        if (searchPath != null && !searchPath.isEmpty()) {
            String[] xpackNames = this.getBuildToolsXpackNames();
            path = this.searchLatestExecutable(xpackNames, searchPath, subPath, executableName);
        }
        if (path != null) {
            File file = new File(path = path.trim());
            if (!file.isDirectory()) {
                path = "";
            }
        } else {
            path = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverBuildToolsPath() = \"" + path + "\"");
        }
        return path;
    }

    protected String getRegistryToolchainInstallFolder(String toolchainName, String subPath, String executableName) {
        String path = null;
        return path;
    }

    @Deprecated
    public String discoverToolchainPath(String toolchainName, String executableName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverToolchainPath(\"" + toolchainName + "\")");
        }
        String path = null;
        String subPath = "bin";
        if (EclipseUtils.isWindows()) {
            String exe = this.addExeExtension(executableName);
            path = this.getRegistryToolchainInstallFolder(toolchainName, subPath, exe);
        }
        String searchPath = null;
        if (path == null) {
            searchPath = this.getToolchainSearchPath(toolchainName);
            if (searchPath.isEmpty() && !(searchPath = this.getToolchainSearchPathOs(toolchainName)).isEmpty()) {
                this.putToolchainSearchPath(toolchainName, searchPath);
            }
            if (!searchPath.isEmpty()) {
                String[] xpackNames = this.getToolchainXpackNames(toolchainName);
                path = this.searchLatestExecutable(xpackNames, searchPath, subPath, executableName);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverToolchainPath(\"" + toolchainName + "\") = \"" + path + "\"");
        }
        return path;
    }

    public String discoverToolchainPath(String toolchainId, String toolchainName, String executableName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverToolchainPath(\"" + toolchainId + ", " + toolchainName + "\")");
        }
        String path = null;
        String subPath = "bin";
        if (EclipseUtils.isWindows()) {
            String exe = this.addExeExtension(executableName);
            path = this.getRegistryToolchainInstallFolder(toolchainName, subPath, exe);
        }
        String searchPath = null;
        if (path == null) {
            searchPath = this.getToolchainSearchPath(toolchainId, toolchainName);
            if (searchPath.isEmpty() && !(searchPath = this.getToolchainSearchPathOs(toolchainId, toolchainName)).isEmpty()) {
                this.putToolchainSearchPath(toolchainId, toolchainName, searchPath);
            }
            if (!searchPath.isEmpty()) {
                String[] xpackNames = this.getToolchainXpackNames(toolchainId, toolchainName);
                path = this.searchLatestExecutable(xpackNames, searchPath, subPath, executableName);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverToolchainPath(\"" + toolchainName + "\") = \"" + path + "\"");
        }
        return path;
    }
}

