/**
 * Copyright (c) 2016 Kiel University and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.elk.core.meta.metaData;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Md Option Target Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.elk.core.meta.metaData.MetaDataPackage#getMdOptionTargetType()
 * @model
 * @generated
 */
public enum MdOptionTargetType implements Enumerator
{
  /**
   * The '<em><b>Parents</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #PARENTS_VALUE
   * @generated
   * @ordered
   */
  PARENTS(0, "parents", "parents"),

  /**
   * The '<em><b>Nodes</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #NODES_VALUE
   * @generated
   * @ordered
   */
  NODES(1, "nodes", "nodes"),

  /**
   * The '<em><b>Edges</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EDGES_VALUE
   * @generated
   * @ordered
   */
  EDGES(2, "edges", "edges"),

  /**
   * The '<em><b>Ports</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #PORTS_VALUE
   * @generated
   * @ordered
   */
  PORTS(3, "ports", "ports"),

  /**
   * The '<em><b>Labels</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #LABELS_VALUE
   * @generated
   * @ordered
   */
  LABELS(4, "labels", "labels");

  /**
   * The '<em><b>Parents</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #PARENTS
   * @model name="parents"
   * @generated
   * @ordered
   */
  public static final int PARENTS_VALUE = 0;

  /**
   * The '<em><b>Nodes</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #NODES
   * @model name="nodes"
   * @generated
   * @ordered
   */
  public static final int NODES_VALUE = 1;

  /**
   * The '<em><b>Edges</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EDGES
   * @model name="edges"
   * @generated
   * @ordered
   */
  public static final int EDGES_VALUE = 2;

  /**
   * The '<em><b>Ports</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #PORTS
   * @model name="ports"
   * @generated
   * @ordered
   */
  public static final int PORTS_VALUE = 3;

  /**
   * The '<em><b>Labels</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #LABELS
   * @model name="labels"
   * @generated
   * @ordered
   */
  public static final int LABELS_VALUE = 4;

  /**
   * An array of all the '<em><b>Md Option Target Type</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static final MdOptionTargetType[] VALUES_ARRAY =
    new MdOptionTargetType[]
    {
      PARENTS,
      NODES,
      EDGES,
      PORTS,
      LABELS,
    };

  /**
   * A public read-only list of all the '<em><b>Md Option Target Type</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final List<MdOptionTargetType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

  /**
   * Returns the '<em><b>Md Option Target Type</b></em>' literal with the specified literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param literal the literal.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static MdOptionTargetType get(String literal)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      MdOptionTargetType result = VALUES_ARRAY[i];
      if (result.toString().equals(literal))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Md Option Target Type</b></em>' literal with the specified name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param name the name.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static MdOptionTargetType getByName(String name)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      MdOptionTargetType result = VALUES_ARRAY[i];
      if (result.getName().equals(name))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Md Option Target Type</b></em>' literal with the specified integer value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the integer value.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static MdOptionTargetType get(int value)
  {
    switch (value)
    {
      case PARENTS_VALUE: return PARENTS;
      case NODES_VALUE: return NODES;
      case EDGES_VALUE: return EDGES;
      case PORTS_VALUE: return PORTS;
      case LABELS_VALUE: return LABELS;
    }
    return null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final int value;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String name;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String literal;

  /**
   * Only this class can construct instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private MdOptionTargetType(int value, String name, String literal)
  {
    this.value = value;
    this.name = name;
    this.literal = literal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int getValue()
  {
    return value;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getName()
  {
    return name;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getLiteral()
  {
    return literal;
  }

  /**
   * Returns the literal value of the enumerator, which is its string representation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String toString()
  {
    return literal;
  }
  
} //MdOptionTargetType
