/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.grandom.ui;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.debug.grandom.generators.GeneratorOptions;
import org.eclipse.elk.core.debug.grandom.ui.internal.GrandomActivator;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;

public final class GeneratorOptionsUtil {
    private static IPreferenceStore preferenceStore;

    private GeneratorOptionsUtil() {
    }

    public static void savePreferences(MapPropertyHolder propertyHolder) {
        GeneratorOptionsUtil.getPreferenceStore();
        for (Map.Entry entry : propertyHolder.getAllProperties().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                preferenceStore.setValue(((IProperty)entry.getKey()).getId(), ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                preferenceStore.setValue(((IProperty)entry.getKey()).getId(), ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Float) {
                preferenceStore.setValue(((IProperty)entry.getKey()).getId(), ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                preferenceStore.setValue(((IProperty)entry.getKey()).getId(), ((Double)value).doubleValue());
                continue;
            }
            preferenceStore.setValue(((IProperty)entry.getKey()).getId(), value.toString());
        }
    }

    public static void loadPreferences(MapPropertyHolder propertyHolder) {
        GeneratorOptionsUtil.getPreferenceStore();
        try {
            Field[] fieldArray = GeneratorOptions.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (IProperty.class.isAssignableFrom(field.getType())) {
                    Object value;
                    IProperty option = (IProperty)field.get(propertyHolder);
                    if (option.getDefault() instanceof Boolean) {
                        value = preferenceStore.getBoolean(option.getId());
                    } else if (option.getDefault() instanceof Integer) {
                        value = preferenceStore.getInt(option.getId());
                    } else if (option.getDefault() instanceof Float) {
                        value = Float.valueOf(preferenceStore.getFloat(option.getId()));
                    } else if (option.getDefault() instanceof Double) {
                        value = preferenceStore.getDouble(option.getId());
                    } else if (option.getDefault() instanceof Enum) {
                        String serializedValue = preferenceStore.getString(option.getId());
                        try {
                            value = Enum.valueOf(option.getDefault().getClass(), serializedValue);
                        }
                        catch (IllegalArgumentException exception) {
                            value = null;
                        }
                    } else {
                        value = option.getDefault() instanceof GeneratorOptions.RandVal ? option.getDefault() : preferenceStore.getString(option.getId());
                    }
                    propertyHolder.setProperty(option, value);
                }
                ++n2;
            }
        }
        catch (IllegalAccessException exception) {
            Status status = new Status(4, "org.eclipse.elk.core.debug.grandom.ui", "Error while loading preferences for graph generation options.");
            StatusManager.getManager().handle((IStatus)status);
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        GrandomActivator instance = GrandomActivator.getInstance();
        if (instance != null) {
            preferenceStore = instance.getPreferenceStore();
        }
        return preferenceStore;
    }
}

