/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;

public class DeploymentHelper {
    private String serverUrl;
    private String login;
    private String password;

    public DeploymentHelper(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DeploymentHelper(String serverUrl, String login, String password) {
        this.serverUrl = serverUrl;
        this.login = login;
        this.password = password;
    }

    public void pullConfig(File file, String jobName2) throws IOException {
        this.receiveConfig(file, this.getConfigUrl(this.serverUrl, jobName2));
    }

    public void pushConfig(File file, String jobName2) throws IOException {
        if (this.testUrl(this.getJobUrl(this.serverUrl, jobName2))) {
            this.sendConfig(file, this.getConfigUrl(this.serverUrl, jobName2));
        } else {
            this.sendConfig(file, this.getCreateUrl(this.serverUrl, jobName2));
        }
    }

    protected String getConfigUrl(String serverUrl, String jobName2) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJobUrl(serverUrl, jobName2));
        builder.append("/config.xml");
        return builder.toString();
    }

    private String getJobUrl(String serverUrl, String jobName2) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(serverUrl);
        builder.append("/job/");
        builder.append(URLEncoder.encode(jobName2, "UTF8"));
        return builder.toString();
    }

    protected String getCreateUrl(String serverUrl, String jobName2) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(serverUrl);
        builder.append("/createItem?name=");
        builder.append(URLEncoder.encode(jobName2, "UTF8"));
        return builder.toString();
    }

    protected boolean testUrl(String serverUrl) throws IOException {
        HttpURLConnection openConnection = this.openConnection(serverUrl, RequestType.GET);
        if (openConnection.getResponseCode() == 404) {
            return false;
        }
        this.checkError(openConnection);
        return true;
    }

    protected void receiveConfig(File file, String configUrl) throws IOException {
        HttpURLConnection openConnection = this.openConnection(configUrl, RequestType.GET);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(openConnection.getInputStream()));
        this.readerToWriter(bufferedWriter, bufferedReader);
        this.checkError(openConnection);
    }

    protected void sendConfig(File file, String configUrl) throws IOException {
        HttpURLConnection openConnection = this.openConnection(configUrl, RequestType.POST);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(openConnection.getOutputStream()));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.readerToWriter(bufferedWriter, bufferedReader);
        this.checkError(openConnection);
    }

    protected void readerToWriter(BufferedWriter bufferedWriter, BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            bufferedWriter.write(line);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    protected HttpURLConnection openConnection(String url, RequestType requestType) throws IOException {
        HttpURLConnection openConnection = (HttpURLConnection)new URL(url).openConnection();
        openConnection.setRequestMethod(requestType.toString());
        openConnection.setRequestProperty("Content-Type", "text/xml");
        openConnection.setDoOutput(true);
        openConnection.setDoInput(true);
        openConnection.setUseCaches(false);
        String authString = String.valueOf(this.login) + ":" + this.password;
        String encoded = new String(Base64.encodeBase64((byte[])authString.getBytes()));
        openConnection.setRequestProperty("Authorization", "Basic " + encoded);
        return openConnection;
    }

    protected void checkError(HttpURLConnection openConnection) throws IOException {
        if (openConnection.getResponseCode() != 200) {
            throw new IOException(openConnection.getResponseMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        GET,
        POST;

    }
}

