/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.contributions;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.model.pattern.commands.PatternLibraryRemovePatternCommand;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.contributions.EditHelper;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PatternMenuContributor
extends EditorMenuContributor {
    public static final String EDIT_ACTION_ID = "edit-pattern";
    public static final String EDIT_TEMPLATE_ACTION_ID = "edit-template-pattern";
    private final EditPatternAction editAction = new EditPatternAction();
    private final EditTemplatePatternAction editTemplateAction = new EditTemplatePatternAction();
    private final GeneratePatternAction generateAction = new GeneratePatternAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this._selection;
        if (selection2.size() == 1) {
            if (selection2.getFirstElement() instanceof PatternLibrary) {
                IContributionItem item = menuManager.find("create-child");
                MenuManager createChildMenuManager = null;
                if (item != null && item instanceof MenuManager) {
                    createChildMenuManager = (MenuManager)item;
                } else {
                    createChildMenuManager = new MenuManager(CoreUIMessages.MenuContributor_newChildGroup_label);
                    menuManager.insertBefore("create-sibling", (IContributionItem)createChildMenuManager);
                }
                for (String name : EGFPatternPlugin.getPatternNatures()) {
                    try {
                        PatternExtension patternExtension = EGFPatternPlugin.getPatternExtension((String)name);
                        CommandParameter descriptor = new CommandParameter(null, (Object)PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS, (Object)patternExtension.getFactory().createPattern(null, "myPattern"));
                        CreatePatternAction createChildAction = new CreatePatternAction(this._activeEditorPart, this._selection, descriptor, (PatternLibrary)selection2.getFirstElement());
                        createChildAction.setText(Messages.bind((String)Messages.ViewpointContributor_newPattern_label, (Object)name));
                        createChildAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)patternExtension.getImageURL()));
                        createChildMenuManager.add((IAction)createChildAction);
                    }
                    catch (CoreException ce) {
                        Activator.getDefault().logError(ce);
                    }
                }
            } else if (selection2.getFirstElement() instanceof Pattern) {
                menuManager.insertBefore("open", (IAction)this.editAction);
                menuManager.insertBefore("open", (IAction)this.editTemplateAction);
            } else if (selection2.getFirstElement() instanceof PatternViewpoint) {
                menuManager.insertBefore("open", (IAction)this.generateAction);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreatePatternAction
    extends CreateChildAction {
        private final PatternLibrary library;

        public CreatePatternAction(IEditorPart editorPart, ISelection selection, Object descriptor, PatternLibrary library) {
            super(editorPart, selection, descriptor);
            this.library = library;
        }

        protected Command createActionCommand(EditingDomain innerEditingDomain, Collection<?> collection) {
            final Command createActionCommand = super.createActionCommand(innerEditingDomain, collection);
            if (UnexecutableCommand.INSTANCE.equals(createActionCommand)) {
                return UnexecutableCommand.INSTANCE;
            }
            return createActionCommand.chain((Command)new AbstractCommand(){
                protected Collection<Pattern> _patterns;

                protected boolean prepare() {
                    return true;
                }

                public void execute() {
                    Collection affectedObjects = createActionCommand.getAffectedObjects();
                    Pattern pattern = (Pattern)affectedObjects.iterator().next();
                    this._patterns = Collections.singletonList(pattern);
                    for (PatternMethod method : pattern.getMethods()) {
                        method.setPatternFilePath(TemplateModelFileHelper.computeFileURI((IPlatformFcore)((IPlatformFcoreProvider)CreatePatternAction.this.library.eResource()).getIPlatformFcore(), (PatternMethod)method));
                    }
                    IProject project = EMFHelper.getProject((Resource)CreatePatternAction.this.library.eResource());
                    try {
                        PatternInitializer initializer = ExtensionHelper.getExtension((PatternNature)pattern.getNature()).createInitializer(project, pattern);
                        initializer.initContent();
                    }
                    catch (PatternException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (ExtensionHelper.MissingExtensionException e) {
                        Activator.getDefault().logError(e);
                    }
                }

                public void undo() {
                    PatternLibraryRemovePatternCommand.performDeletePatterns((Resource)CreatePatternAction.this.library.eResource(), this._patterns);
                }

                public void redo() {
                    PatternLibraryRemovePatternCommand.performRestorePatterns((Resource)CreatePatternAction.this.library.eResource(), this._patterns);
                }
            });
        }
    }

    private final class EditPatternAction
    extends PatternAction {
        public EditPatternAction() {
            super(Messages.ViewpointContributor_openAction_label, PatternMenuContributor.EDIT_ACTION_ID);
        }

        public void run() {
            EditHelper.openPatternEditor(PatternMenuContributor.this._parent.getPage(), this.getPattern());
        }
    }

    private final class EditTemplatePatternAction
    extends PatternAction {
        public EditTemplatePatternAction() {
            super(Messages.ViewpointContributor_openTemplateAction_label, PatternMenuContributor.EDIT_TEMPLATE_ACTION_ID);
        }

        public void run() {
            Pattern patternInTransactionalEditingDomain = this.getPatternInTransactionalEditingDomain();
            if (patternInTransactionalEditingDomain == null) {
                MessageDialog.openInformation((Shell)PatternMenuContributor.this._parent.getPage().getWorkbenchWindow().getShell(), (String)Messages.ViewpointContributor_missingPattern_title, (String)Messages.ViewpointContributor_missingPattern_message);
            } else {
                Pattern pattern = this.getPattern();
                EditHelper.openTemplateBasicEditor(PatternMenuContributor.this._parent.getPage(), pattern);
            }
        }
    }

    private final class GeneratePatternAction
    extends Action {
        public GeneratePatternAction() {
            super(Messages.ViewpointContributor_generatePatternAction_label);
            this.setId(this.getText());
        }

        public void run() {
            if (PatternMenuContributor.this._selection == null) {
                throw new IllegalStateException();
            }
            IStructuredSelection sselection = (IStructuredSelection)PatternMenuContributor.this._selection;
            if (sselection.isEmpty() || !(sselection.getFirstElement() instanceof EObject)) {
                throw new IllegalStateException();
            }
            final Resource resource = ((EObject)sselection.getFirstElement()).eResource();
            WorkspaceJob job = new WorkspaceJob(NLS.bind((String)EGFPatternMessages.pattern_translation_label, (Object)resource.getURI())){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    MultiStatus statii;
                    block8: {
                        statii = new MultiStatus(Activator.getDefault().getPluginID(), 4, EGFPatternMessages.PatternTranslation_pattern_exception, null);
                        HashSet patterns = new HashSet();
                        PatternHelper patternCollector = PatternHelper.createCollector();
                        try {
                            try {
                                patterns.addAll(patternCollector.getPatterns(resource.getURI()));
                                TranslationHelper.translate((IProgressMonitor)monitor, patterns);
                            }
                            catch (OperationCanceledException oce) {
                                throw oce;
                            }
                            catch (Throwable t) {
                                if (t instanceof CoreException) {
                                    statii.add(((CoreException)t).getStatus());
                                } else {
                                    statii.add(Activator.getDefault().newStatus(4, EGFPatternMessages.PatternTranslation_pattern_exception, t));
                                }
                                monitor.done();
                                patterns.clear();
                                patternCollector.clear();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            patterns.clear();
                            patternCollector.clear();
                            throw throwable;
                        }
                        monitor.done();
                        patterns.clear();
                        patternCollector.clear();
                    }
                    return statii.getChildren().length != 0 ? statii : Status.OK_STATUS;
                }
            };
            job.setRule(ProjectHelper.getRule(Collections.singletonList(EMFHelper.getProject((Resource)resource))));
            job.schedule();
        }
    }

    private abstract class PatternAction
    extends Action {
        public PatternAction(String label, String id) {
            super(label);
            this.setId(id);
        }

        protected Pattern getPattern() {
            if (PatternMenuContributor.this._selection == null) {
                throw new IllegalStateException();
            }
            IStructuredSelection sselection = (IStructuredSelection)PatternMenuContributor.this._selection;
            if (sselection.size() != 1 || !(sselection.getFirstElement() instanceof Pattern)) {
                throw new IllegalStateException();
            }
            return (Pattern)sselection.getFirstElement();
        }

        protected Pattern getPatternInTransactionalEditingDomain() {
            Pattern pattern = this.getPattern();
            return PatternHelper.TRANSACTIONNAL_COLLECTOR.getPattern(pattern.getID());
        }
    }
}

