/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.dialogs;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.AbstractFilteredItemsSelectionDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.provider.FcoreItemProviderAdapterFactory;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.egf.model.fprod.provider.FprodItemProviderAdapterFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivitySelectionDialog
extends AbstractFilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog";
    private Activity _activity;
    private EditingDomain _editingDomain;
    private ComposedAdapterFactory _adapterFactory;
    private IPlatformFcore[] _fcores = EGFCorePlugin.getPlatformFcores();

    protected ILabelProvider getLabelProvider() {
        return new ActivityLabelProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelDecorator getSelectionLabelProvider() {
        return new ActivitySelectionLabelProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelProvider getDetailsLabelProvider() {
        return new ActivityDetailsLabelProvider((AdapterFactory)this._adapterFactory);
    }

    public ActivitySelectionDialog(Shell shell, IPlatformFcore fcore, boolean multipleSelection) {
        this(shell, multipleSelection);
        if (fcore != null) {
            this._fcores = new IPlatformFcore[]{fcore};
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)fcore.getPlatformBundle().getBundleId()));
        }
    }

    public ActivitySelectionDialog(Shell shell, Activity activity, boolean multipleSelection) {
        super(shell, multipleSelection);
        this._editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        if (activity != null) {
            this._activity = (Activity)this._editingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)activity), true);
        }
        this._adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FprodItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.setTitle(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogTitle, (Object)Activity.class.getSimpleName()));
        this.setMessage(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogMessage, (Object)Activity.class.getSimpleName()));
        this.setListLabelProvider(this.getLabelProvider());
        this.setListSelectionLabelDecorator(this.getSelectionLabelProvider());
        this.setDetailsLabelProvider(this.getDetailsLabelProvider());
        this.setSelectionHistory(new ActivitySelectionHistory());
        if (this._activity != null && this._activity.eResource() != null) {
            IPlatformFcore fcore = ((IPlatformFcoreProvider)this._activity.eResource()).getIPlatformFcore();
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)fcore.getPlatformBundle().getBundleId()));
        } else {
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
        }
    }

    public ActivitySelectionDialog(Shell shell, boolean multipleSelection) {
        this(shell, (Activity)null, multipleSelection);
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() != 0) {
            UniqueEList activities = new UniqueEList();
            for (Object object : selection.toList()) {
                if (!(object instanceof Activity)) continue;
                activities.add((Activity)object);
            }
            this.notifySelectionListeners(activities.toArray());
        }
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Activity> resultToReturn = new ArrayList<Activity>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof Activity) {
                resultToReturn.add((Activity)result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ActivitySearchItemsFilter();
    }

    /*
     * Exception decompiling
     */
    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean selectElement(EObject eObject) {
        return true;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFModelEditorPlugin.getPlugin().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFModelEditorPlugin.getPlugin().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPlatformFcore) {
            IPlatformFcore fc = (IPlatformFcore)item;
            return fc.getURI().toString();
        }
        return null;
    }

    protected Comparator<Activity> getItemsComparator() {
        return new ActivitySearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, EGFModelEditorPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", null);
    }

    private class ActivityDetailsLabelProvider
    extends LabelProvider {
        ILabelProvider _adapterFactoryLabelProvider;

        public ActivityDetailsLabelProvider(AdapterFactory adapterFactory) {
            this._adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        }

        public Image getImage(Object element) {
            if (!(element instanceof Activity)) {
                return this._adapterFactoryLabelProvider.getImage(element);
            }
            Activity activity = (Activity)element;
            if (activity.eResource() == null) {
                return this._adapterFactoryLabelProvider.getImage((Object)activity);
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)activity.eResource()).getIPlatformFcore();
            if (fcore == null) {
                return this._adapterFactoryLabelProvider.getImage((Object)activity);
            }
            File file = new File(fcore.getPlatformBundle().getInstallLocation());
            if (file.exists() && file.isDirectory()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/directory.gif");
            }
            if (file.exists() && file.isFile()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/jar.gif");
            }
            return EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif");
        }

        public String getText(Object element) {
            if (!(element instanceof Activity)) {
                return this._adapterFactoryLabelProvider.getText(element);
            }
            Activity activity = (Activity)element;
            if (activity.eResource() == null) {
                return this._adapterFactoryLabelProvider.getText((Object)activity);
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)activity.eResource()).getIPlatformFcore();
            if (fcore == null) {
                return this._adapterFactoryLabelProvider.getText((Object)activity);
            }
            StringBuffer buffer = new StringBuffer();
            if (fcore.getPlatformBundle().isTarget()) {
                buffer.append(" [Target]");
            } else {
                buffer.append(" [Workspace]");
            }
            buffer.append(" [");
            buffer.append(fcore.getPlatformBundle().getInstallLocation());
            buffer.append("]");
            return buffer.toString();
        }
    }

    private class ActivityLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public ActivityLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object element) {
            if (!(element instanceof Activity)) {
                return super.getText(element);
            }
            return ((Activity)element).getName();
        }

        public String decorateText(String text, Object element) {
            return this.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActivitySearchComparator
    implements Comparator<Activity>,
    Serializable {
        public static final long serialVersionUID = 1L;

        private ActivitySearchComparator() {
        }

        @Override
        public int compare(Activity a1, Activity a2) {
            if (a1.getName() == null && a2.getName() == null) {
                return 0;
            }
            if (a1.getName() != null && a2.getName() == null) {
                return -1;
            }
            if (a1.getName() == null && a2.getName() != null) {
                return 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }

    private class ActivitySearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private ActivitySearchItemsFilter() {
            super((FilteredItemsSelectionDialog)ActivitySelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof Activity)) {
                return false;
            }
            Activity activity = (Activity)item;
            if (activity.getName() == null) {
                return true;
            }
            return this.matches(activity.getName());
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof Activity;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            return filter instanceof ActivitySearchItemsFilter;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            return filter instanceof ActivitySearchItemsFilter;
        }
    }

    private class ActivitySelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String TAG_URI = "path";

        protected Object restoreItemFromMemento(IMemento memento) {
            block9: {
                String tag = memento.getString(TAG_URI);
                if (tag == null) {
                    return null;
                }
                try {
                    ActivitySelectionDialog.this._activity = (Activity)ActivitySelectionDialog.this._editingDomain.getResourceSet().getEObject(URI.createURI((String)tag), true);
                    IPlatformFcore fcore = ((IPlatformFcoreProvider)ActivitySelectionDialog.this._activity.eResource()).getIPlatformFcore();
                    if (fcore == null) break block9;
                    IPlatformFcore[] iPlatformFcoreArray = ActivitySelectionDialog.this._fcores;
                    int n = iPlatformFcoreArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPlatformFcore innerFcore = iPlatformFcoreArray[n2];
                        if (innerFcore.equals(fcore)) {
                            Activity activity = ActivitySelectionDialog.this._activity;
                            return activity;
                        }
                        try {
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {}
                        break;
                    }
                }
                finally {
                    ActivitySelectionDialog.this._activity = null;
                }
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            if (ActivitySelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    element.putString(TAG_URI, EcoreUtil.getURI((EObject)((Activity)items[i])).toString());
                    ++i;
                }
            } else if (ActivitySelectionDialog.this._activity != null) {
                element.putString(TAG_URI, EcoreUtil.getURI((EObject)ActivitySelectionDialog.this._activity).toString());
            }
        }
    }

    private class ActivitySelectionLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public ActivitySelectionLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof Activity)) {
                return this.getText(element);
            }
            return String.valueOf(this.getText(element)) + " -> " + EcoreUtil.getURI((EObject)((Activity)element)).trimFragment();
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }
}

