/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import java.util.List;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class MethodLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private List<String> parentMethods;

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof PatternMethod && this.isOverride(element)) {
            return Activator.getDefault().getImage("obj16/method_override.png");
        }
        return Activator.getDefault().getImage("obj16/method.gif");
    }

    private boolean isOverride(Object element) {
        if (element instanceof PatternMethod) {
            PatternMethod patternMethod = (PatternMethod)element;
            Pattern pattern = patternMethod.getPattern();
            this.parentMethods = PatternUIHelper.getPatternParentMethodsNameList(pattern);
            for (String parentMethod : this.parentMethods) {
                String elementName = patternMethod.getName();
                if (!elementName.equals(parentMethod)) continue;
                return true;
            }
        }
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof PatternMethod) {
            PatternMethod patternMethod = (PatternMethod)element;
            return patternMethod.getName();
        }
        return "";
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }
}

