/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.test.context.factorycomponent.resource;

import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.test.EGFCoreTestPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.FactoryComponentManagerFactory;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.manager.IFactoryComponentManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;

public class ContextFactoryComponentResource
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextFactoryComponentResource.class);
    }

    public void testInvokeFC1() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.fcs/fc/fc1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextFactoryComponentResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextFactoryComponentResource.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        Activity activity = (Activity)eObject;
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        IActivityManager manager = producer.createActivityManager(activity);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextFactoryComponentResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                return;
            }
        }
    }

    public void testContractFC1() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.fcs/fc/fc1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextFactoryComponentResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextFactoryComponentResource.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof FactoryComponent));
        FactoryComponent fc = (FactoryComponent)eObject;
        IFactoryComponentManager manager = FactoryComponentManagerFactory.createProductionManager((FactoryComponent)fc);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextFactoryComponentResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                return;
            }
        }
        Float amount = (Float)manager.getProductionContext().getOutputValue((Object)"amount", Float.class);
        ContextFactoryComponentResource.assertEquals((Object)new Float("110"), (Object)amount);
    }

    public void testContractList() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.egf.example.fcs/fc/fc1.fcore");
        Resource resource = ResourceHelper.loadResource((ResourceSet)resourceSet, (URI)uri);
        ContextFactoryComponentResource.assertNotNull((String)NLS.bind((String)"Unable to load Resource ''{0}''", (Object)uri.toString()), (Object)resource);
        EObject eObject = (EObject)resource.getContents().get(0);
        ContextFactoryComponentResource.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof FactoryComponent));
        FactoryComponent fc = (FactoryComponent)eObject;
        IFactoryComponentManager manager = FactoryComponentManagerFactory.createProductionManager((FactoryComponent)fc);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    EGFCoreTestPlugin.getDefault().logError(e2);
                    ContextFactoryComponentResource.fail((String)e2.getMessage());
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                EGFCoreTestPlugin.getDefault().logError(e);
                ContextFactoryComponentResource.fail((String)e.getMessage());
                return;
            }
        }
        Collection parameters = (Collection)manager.getProductionContext().getOutputValue((Object)"parameters", Collection.class);
        ContextFactoryComponentResource.assertEquals((int)2, (int)parameters.size());
    }
}

