/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fprod.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.fprod.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.util.FcoreValidator;
import org.eclipse.egf.model.fprod.FactoryComponentInvocation;
import org.eclipse.egf.model.fprod.FprodPackage;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.egf.model.fprod.Task;
import org.eclipse.egf.model.fprod.TaskContract;
import org.eclipse.egf.model.fprod.TaskContractContainer;
import org.eclipse.egf.model.fprod.TaskInvocation;
import org.eclipse.egf.model.helper.ValidationHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FprodValidator
extends EObjectValidator {
    public static final FprodValidator INSTANCE = new FprodValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.fprod";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected FcoreValidator fcoreValidator = FcoreValidator.INSTANCE;

    public FprodValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return FprodPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateProductionPlan((ProductionPlan)value, diagnostics, context);
            }
            case 1: {
                return this.validateProductionPlanInvocation((ProductionPlanInvocation)value, diagnostics, context);
            }
            case 2: {
                return this.validateFactoryComponentInvocation((FactoryComponentInvocation)value, diagnostics, context);
            }
            case 3: {
                return this.validateTaskInvocation((TaskInvocation)value, diagnostics, context);
            }
            case 4: {
                return this.validateTask((Task)value, diagnostics, context);
            }
            case 5: {
                return this.validateTaskContract((TaskContract)value, diagnostics, context);
            }
            case 6: {
                return this.validateTaskContractContainer((TaskContractContainer)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateProductionPlan(ProductionPlan productionPlan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)productionPlan, diagnostics, context);
    }

    public boolean validateProductionPlanInvocation(ProductionPlanInvocation<?> productionPlanInvocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)productionPlanInvocation, diagnostics, context);
    }

    public boolean validateFactoryComponentInvocation(FactoryComponentInvocation factoryComponentInvocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)factoryComponentInvocation, diagnostics, context);
    }

    public boolean validateTaskInvocation(TaskInvocation taskInvocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)taskInvocation, diagnostics, context);
    }

    public boolean validateTask(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)task, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivity_ActivityCycle((Activity)task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_LoadableValue(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_ValidValue(task, diagnostics, context);
        }
        return result;
    }

    public boolean validateTask_LoadableValue(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getValue() == null) {
            return true;
        }
        if (!ValidationHelper.isLoadableClass((EObject)task, (String)task.getValue(), context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{NLS.bind((String)"Unable to load ''{0}''.", (Object)task.getValue()), FprodValidator.getObjectLabel((EObject)task, context)}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTask_ValidValue(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (task.getValue() == null) {
            return true;
        }
        if (!ValidationHelper.isValidClass((EObject)task, ITaskProduction.class, (String)task.getValue(), context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{NLS.bind((String)"Type mismatch ''{0}'' with ''{1}''.", (Object)ITaskProduction.class.getName(), (Object)task.getValue()), FprodValidator.getObjectLabel((EObject)task, context)}, new Object[]{task}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTaskContract(TaskContract taskContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms((EObject)taskContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivityContract_MandatoryName((ActivityContract)taskContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.fcoreValidator.validateActivityContract_UniqueName((ActivityContract)taskContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateTaskContractContainer(TaskContractContainer taskContractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)taskContractContainer, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

