/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.ObjectHolder;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.util.PatternSwitch;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public abstract class AssemblyHelper {
    protected final Pattern pattern;
    protected final StringBuilder content = new StringBuilder(1000);
    protected int orchestrationIndex;

    public AssemblyHelper(Pattern pattern) {
        this.pattern = pattern;
    }

    public String visit() throws PatternException {
        this.orchestrationIndex = -1;
        String read = this.getMethodContent(this.pattern.getHeaderMethod());
        if (read != null) {
            this.content.append(read);
        }
        this.beginOrchestration();
        if (this.orchestrationIndex == -1) {
            throw new PatternException(Messages.assembly_error6);
        }
        this.addVariable(this.pattern);
        this.visitOrchestration(this.pattern);
        this.endOrchestration();
        read = this.getMethodContent(this.pattern.getFooterMethod());
        if (read != null) {
            this.content.append(read);
        }
        return this.content.toString();
    }

    protected void endOrchestration() throws PatternException {
    }

    protected void beginOrchestration() throws PatternException {
        this.orchestrationIndex = this.content.length();
    }

    protected void addVariable(Pattern pattern) throws PatternException {
        StringBuilder inits = new StringBuilder(1000);
        Pattern parent = pattern.getSuperPattern();
        inits.append(this.getMethodContent(pattern.getInitMethod()));
        while (parent != null) {
            inits.insert(0, this.getMethodContent(parent.getInitMethod()));
            parent = parent.getSuperPattern();
        }
        this.content.append((CharSequence)inits);
    }

    protected final void handleParameters(int insertionIndex) throws PatternException {
    }

    protected abstract void call(PatternCall var1) throws PatternException;

    protected abstract void call(PatternInjectedCall var1) throws PatternException;

    protected void visitOrchestration(Pattern pattern) throws PatternException {
        EList orchestration = pattern.getOrchestration();
        while (orchestration.isEmpty() && pattern.getSuperPattern() != null) {
            orchestration = pattern.getSuperPattern().getOrchestration();
            pattern = pattern.getSuperPattern();
        }
        if (orchestration.isEmpty()) {
            throw new PatternException(Messages.bind((String)Messages.assembly_error8, (Object)pattern.getName()));
        }
        for (Call element : orchestration) {
            String read = this.getContent(element);
            if (read == null) continue;
            this.content.append(read);
        }
    }

    private String getContent(Call unit) throws PatternException {
        final ObjectHolder holder = new ObjectHolder();
        String result = (String)new PatternSwitch<String>(){

            public String caseMethodCall(MethodCall object) {
                try {
                    PatternMethod called = object.getCalled();
                    called = AssemblyHelper.this.pattern.getMethod(called.getName());
                    return AssemblyHelper.this.getMethodContent(called);
                }
                catch (PatternException e) {
                    holder.object = e;
                    return "";
                }
            }

            public String casePatternInjectedCall(PatternInjectedCall object) {
                try {
                    AssemblyHelper.this.call(object);
                }
                catch (PatternException e) {
                    holder.object = e;
                }
                return "";
            }

            public String casePatternCall(PatternCall object) {
                try {
                    AssemblyHelper.this.call(object);
                }
                catch (PatternException e) {
                    holder.object = e;
                }
                return "";
            }

            public String defaultCase(EObject object) {
                throw new IllegalStateException(Messages.bind((String)Messages.assembly_error1, (Object)object.eClass().getName()));
            }
        }.doSwitch((EObject)unit);
        if (holder.object != null) {
            throw (PatternException)((Object)holder.object);
        }
        return result;
    }

    private String getMethodContent(PatternMethod object) throws PatternException {
        URI uri = object.getPatternFilePath();
        try {
            return FileHelper.getContent(PatternHelper.getPlatformFcore((PatternElement)object.getPattern()), uri);
        }
        catch (CoreException e) {
            throw new PatternException((Throwable)e);
        }
        catch (IOException e) {
            throw new PatternException((Throwable)e);
        }
    }
}

