/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.session;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBundleSession {
    public static String PROJECT_BUNDLE_SESSION = "org.eclipse.egf.core.session.project.bundle.session";
    private BundleContext _context;
    private Map<IPluginModelBase, Bundle> _projectBundles = new HashMap<IPluginModelBase, Bundle>();
    private List<Bundle> _uninstalled = new ArrayList<Bundle>();

    public ProjectBundleSession(BundleContext context) {
        Assert.isNotNull((Object)context);
        this._context = context;
    }

    public BundleContext getBundleContext() {
        return this._context;
    }

    private Bundle installBundle(IPluginModelBase base) throws CoreException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Bundle uninstalled = this.checkTargetBundle(base);
        if (uninstalled != null) {
            bundles.add(uninstalled);
        }
        IResource manifest = base.getUnderlyingResource();
        Bundle bundle = null;
        String location = null;
        try {
            location = "reference:" + URLDecoder.decode(manifest.getProject().getLocationURI().toURL().toExternalForm(), System.getProperty("file.encoding"));
            bundle = this.getBundleFromItsLocation(location);
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_URLFailure, (Object)manifest.getProject().getName()), t));
        }
        if (bundle == null) {
            this.checkDependencies(base);
            bundle = this.installBundle(location);
            IProject project = base.getUnderlyingResource().getProject();
            this.addOutputFoldersToBundleClasspath(project, bundle);
            this._projectBundles.put(base, bundle);
            bundles.add(bundle);
        }
        this.refreshPackages(bundles.toArray(new Bundle[bundles.size()]));
        if (EGFCorePlugin.getDefault().isDebugging()) {
            EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is installed.", (Object)bundle.getSymbolicName()));
        }
        return bundle;
    }

    private Bundle checkTargetBundle(IPluginModelBase base) throws CoreException {
        Bundle bundle = Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)base));
        if (bundle == null) {
            return null;
        }
        if (bundle.getState() == 32 || bundle.getState() == 8) {
            try {
                bundle.stop();
            }
            catch (Throwable t) {
                throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_StoppingFailure, (Object)bundle.getSymbolicName()), t));
            }
        }
        if (bundle.getState() == 2 || bundle.getState() == 4) {
            try {
                bundle.uninstall();
            }
            catch (Throwable t) {
                throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_UninstallationFailure, (Object)bundle.getSymbolicName()), t));
            }
        }
        this._uninstalled.add(bundle);
        if (EGFCorePlugin.getDefault().isDebugging()) {
            EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Target Bundle ''{0}'' is uninstalled.", (Object)bundle.getSymbolicName()));
        }
        return bundle;
    }

    private void checkDependencies(IPluginModelBase base) throws CoreException {
        IPluginModelBase workspaceModel;
        int n;
        int n2;
        IPluginModelBase[] iPluginModelBaseArray;
        BundleDescription description = base.getBundleDescription();
        if (description == null) {
            return;
        }
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n3 = bundleSpecificationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    this.installBundle(workspaceModel);
                    break;
                }
                ++n;
            }
            ++n4;
        }
        bundleSpecificationArray = description.getImportPackages();
        n3 = bundleSpecificationArray.length;
        n4 = 0;
        while (n4 < n3) {
            BundleSpecification importPackage = bundleSpecificationArray[n4];
            iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            n2 = iPluginModelBaseArray.length;
            n = 0;
            while (n < n2) {
                workspaceModel = iPluginModelBaseArray[n];
                ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                int n5 = exportPackageDescriptionArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ExportPackageDescription export = exportPackageDescriptionArray[n6];
                    if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                        this.installBundle(workspaceModel);
                        break;
                    }
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
    }

    private Bundle installBundle(String pluginLocation) throws CoreException {
        Bundle target = null;
        try {
            target = this._context.installBundle(pluginLocation);
        }
        catch (Throwable t) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)pluginLocation), t));
        }
        if (target == null) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_InstallationFailure, (Object)pluginLocation), null));
        }
        int state = target.getState();
        if (state != 2) {
            throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_IllegalBundleState, (Object)target, (Object)state), null));
        }
        return target;
    }

    public Class<?> getClass(IProject project, String qualifiedName) throws CoreException {
        Bundle bundle = this.getBundle(project);
        if (bundle != null) {
            try {
                return bundle.loadClass(qualifiedName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_LoadFailure, (Object)qualifiedName, (Object)bundle.getSymbolicName()), cnfe));
            }
        }
        return null;
    }

    private void addOutputFoldersToBundleClasspath(IProject project, Bundle bundle) throws CoreException {
        List outputFolders = JavaHelper.getStringOutputFolders((IJavaProject)JavaCore.create((IProject)project));
        BaseData bundleData = (BaseData)((AbstractBundle)bundle).getBundleData();
        StringBuilder classpath = new StringBuilder();
        if (outputFolders.size() == 0) {
            classpath.append(".");
        } else {
            Iterator it = outputFolders.iterator();
            while (it.hasNext()) {
                if (classpath.length() > 0) {
                    classpath.append(",");
                }
                classpath.append((String)it.next());
            }
        }
        bundleData.setClassPathString(classpath.toString());
    }

    private Bundle getBundleFromItsLocation(String location) {
        Bundle[] bundles = this._context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (location.equals(bundles[i].getLocation())) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public Bundle getBundle(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null) {
            return null;
        }
        if (model.getUnderlyingResource() == null) {
            return Platform.getBundle((String)BundleHelper.getBundleId((IPluginModelBase)model));
        }
        Bundle bundle = this._projectBundles.get(model);
        if (bundle == null) {
            return this.installBundle(model);
        }
        return bundle;
    }

    public Bundle getBundle(IProject project) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model == null) {
            return null;
        }
        Bundle bundle = this._projectBundles.get(model);
        if (bundle == null) {
            return this.installBundle(model);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] bundles) {
        ServiceReference packageAdminReference = this._context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)this._context.getService(packageAdminReference);
        }
        if (packageAdmin == null) return;
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        this._context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this._context.removeFrameworkListener(listener);
            this._context.ungetService(packageAdminReference);
            return;
        }
    }

    public void dispose() throws CoreException {
        for (Map.Entry<IPluginModelBase, Bundle> entry : this._projectBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                this.uninstallBundle(bundle);
                if (!EGFCorePlugin.getDefault().isDebugging()) continue;
                EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Workspace Bundle ''{0}'' is uninstalled.", (Object)bundle.getSymbolicName()));
            }
            catch (BundleException be) {
                throw new CoreException(EGFCorePlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_UninstallationFailure, (Object)bundle.getSymbolicName()), be));
            }
        }
        for (Bundle bundle : this._uninstalled) {
            Bundle installed = this.installBundle(bundle.getLocation());
            this.refreshPackages(new Bundle[]{installed});
            if (!EGFCorePlugin.getDefault().isDebugging()) continue;
            EGFCorePlugin.getDefault().logInfo(NLS.bind((String)"Target Bundle ''{0}'' is installed.", (Object)installed.getSymbolicName()));
        }
        this._projectBundles.clear();
        this._uninstalled.clear();
    }

    private void uninstallBundle(Bundle bundle) throws BundleException {
        bundle.uninstall();
        this.refreshPackages(null);
    }
}

