/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.console;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.console.internal.ConsoleDocument;
import org.eclipse.egf.console.internal.ConsoleFactory;
import org.eclipse.egf.console.l10n.ConsoleMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class Console
extends MessageConsole
implements IPropertyChangeListener {
    private Color _debugColor;
    private Color _errorColor;
    private Color _infoColor;
    private Color _warningColor;
    private MessageConsoleStream _debugStream;
    private MessageConsoleStream _errorStream;
    private MessageConsoleStream _infoStream;
    private MessageConsoleStream _warningStream;
    private boolean _showOnMessage;
    private ConsoleDocument _document;
    private IConsoleManager _consoleManager;
    private static final DateFormat TIME_FORMAT;
    private boolean _visible = false;
    private boolean _initialized = false;
    private static final String NESTING = "  ";

    static {
        SimpleDateFormat format;
        try {
            format = new SimpleDateFormat(ConsoleMessages.Console_resultTimeFormat);
        }
        catch (RuntimeException runtimeException) {
            format = new SimpleDateFormat("'(took 'm:ss.SSS')')");
        }
        TIME_FORMAT = format;
    }

    public Console() {
        super(ConsoleMessages.EGF_Console, EGFConsolePlugin.getDefault().getImageDescriptor("eview16/console_view.gif"));
        this.setType("EGF");
        this._showOnMessage = EGFConsolePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.egf.console.internal.showOnMessage");
        this._document = new ConsoleDocument();
        this._consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        EGFConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public MessageConsoleStream getDebugStream() {
        return this._debugStream;
    }

    public MessageConsoleStream getErrorStream() {
        return this._errorStream;
    }

    public MessageConsoleStream getInfoStream() {
        return this._infoStream;
    }

    public MessageConsoleStream getWarningStream() {
        return this._warningStream;
    }

    public void logDebug(String line) {
        this.logDebug(line, 0);
    }

    public void logDebug(String line, int nesting) {
        if (this._showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(0, line, nesting);
    }

    public void logError(String line) {
        this.logError(line, 0);
    }

    public void logError(String line, int nesting) {
        if (this._showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, line, nesting);
    }

    public void logThrowable(String message, Throwable throwable) {
        this.logThrowable(message, throwable, 0);
    }

    public void logThrowable(String message, Throwable throwable, int nesting) {
        this.logStatus(EGFConsolePlugin.getDefault().newErrorStatus(message, throwable), nesting);
    }

    public void logStatus(IStatus status) {
        this.logStatus(status, 0);
    }

    public void logStatus(IStatus status, int nesting) {
        if (this._showOnMessage) {
            this.bringConsoleToFront();
        }
        this.outputStatus(status, nesting);
        if (status != null && status.getSeverity() == 4) {
            this.logError(ConsoleMessages.Console_see_your_log_file, nesting);
        }
    }

    public void logInfo(String line) {
        this.logInfo(line, 0);
    }

    public void logInfo(String line, int nesting) {
        if (this._showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(2, line, nesting);
    }

    public void logWarning(String line) {
        this.logWarning(line, 0);
    }

    public void logWarning(String line, int nesting) {
        this.appendLine(3, line, nesting);
    }

    private void bringConsoleToFront() {
        if (!this._visible) {
            this._consoleManager.addConsoles(new IConsole[]{this});
        }
        this._consoleManager.showConsoleView((IConsole)this);
    }

    protected void init() {
        super.init();
        this.initLimitOutput();
        this.initWrapSetting();
        EGFConsolePlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)Console.this);
                Console.this.initializeStreams();
                Console.this.dump();
            }
        });
    }

    private void initWrapSetting() {
        IPreferenceStore store = EGFConsolePlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.egf.console.internal.wrap")) {
            this.setConsoleWidth(store.getInt("org.eclipse.egf.console.internal.width"));
        } else {
            this.setConsoleWidth(-1);
        }
    }

    private void initLimitOutput() {
        IPreferenceStore store = EGFConsolePlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.egf.console.internal.limitOutput")) {
            int lowWater = store.getInt("org.eclipse.egf.console.internal.lowWaterMark");
            int highWater = store.getInt("org.eclipse.egf.console.internal.highWaterMark");
            this.setWaterMarks(lowWater, highWater);
        } else {
            this.setWaterMarks(-1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeStreams() {
        ConsoleDocument consoleDocument = this._document;
        synchronized (consoleDocument) {
            if (!this._initialized) {
                this._debugStream = this.newMessageStream();
                this._errorStream = this.newMessageStream();
                this._infoStream = this.newMessageStream();
                this._warningStream = this.newMessageStream();
                this._debugColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.debugColor");
                this._debugStream.setColor(this._debugColor);
                this._errorColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.errorColor");
                this._errorStream.setColor(this._errorColor);
                this._infoColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.informationColor");
                this._infoStream.setColor(this._infoColor);
                this._warningColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.warningColor");
                this._warningStream.setColor(this._warningColor);
                Font f = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("org.eclipse.egf.console.internal.font");
                this.setFont(f);
                this._initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump() {
        ConsoleDocument consoleDocument = this._document;
        synchronized (consoleDocument) {
            this._visible = true;
            ConsoleDocument.ConsoleLine[] lines = this._document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line._type, line._line, line._nesting);
                ++i;
            }
            this._document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line, int nesting) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING);
            ++i;
        }
        if (this._showOnMessage) {
            this.bringConsoleToFront();
        }
        this.showConsole();
        ConsoleDocument consoleDocument = this._document;
        synchronized (consoleDocument) {
            if (this._visible) {
                switch (type) {
                    case 0: {
                        buffer.append(line);
                        this.getDebugStream().println(buffer.toString());
                        break;
                    }
                    case 1: {
                        buffer.append(line);
                        this.getErrorStream().println(buffer.toString());
                        break;
                    }
                    case 2: {
                        buffer.append(line);
                        this.getInfoStream().println(buffer.toString());
                        break;
                    }
                    case 3: {
                        buffer.append(line);
                        this.getWarningStream().println(buffer.toString());
                    }
                }
            } else {
                this._document.appendConsoleLine(type, line, nesting);
            }
        }
    }

    private void showConsole() {
        this.show(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this._document;
        synchronized (consoleDocument) {
            this._visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        super.dispose();
        if (this._debugColor != null) {
            this._debugColor.dispose();
        }
        if (this._errorColor != null) {
            this._errorColor.dispose();
        }
        if (this._infoColor != null) {
            this._infoColor.dispose();
        }
        if (this._warningColor != null) {
            this._warningColor.dispose();
        }
        EGFConsolePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void outputStatus(IStatus status, int nesting) {
        if (status == null) {
            return;
        }
        this.outputStatusMessage(status, nesting);
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.outputStatus(children[i], nesting + 1);
                ++i;
            }
        }
        if (status.getException() instanceof InvocationTargetException) {
            if (((InvocationTargetException)status.getException()).getTargetException() instanceof CoreException) {
                this.outputStatus(((CoreException)((InvocationTargetException)status.getException()).getTargetException()).getStatus(), nesting + 1);
            }
        } else if (status.getException() instanceof CoreException) {
            this.outputStatus(((CoreException)status.getException()).getStatus(), nesting + 1);
        }
    }

    private void outputStatusMessage(IStatus status, int nesting) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING);
            ++i;
        }
        if (status.getMessage() != null && status.getMessage().trim().length() > 0 && (status.getException() == null || status.getException() != null && !status.getMessage().equals(status.getException().toString()))) {
            buffer.append(status.getMessage());
            if (status.getSeverity() == 4) {
                this.appendLine(1, buffer.toString(), 0);
            } else if (status.getSeverity() == 2) {
                this.appendLine(3, buffer.toString(), 0);
            } else {
                this.appendLine(2, buffer.toString(), 0);
            }
            buffer = new StringBuffer();
            i = 0;
            while (i < nesting + 1) {
                buffer.append(NESTING);
                ++i;
            }
        }
        if (status.getException() != null) {
            buffer.append(this.messageLineForStatus(status));
            if (status.getSeverity() == 4) {
                this.appendLine(1, buffer.toString(), 0);
            } else if (status.getSeverity() == 2) {
                this.appendLine(3, buffer.toString(), 0);
            } else {
                this.appendLine(2, buffer.toString(), 0);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this._visible) {
            Color newColor;
            if (property.equals("org.eclipse.egf.console.internal.wrap") || property.equals("org.eclipse.egf.console.internal.width")) {
                this.initWrapSetting();
            } else if (property.equals("org.eclipse.egf.console.internal.limitOutput") || property.equals("org.eclipse.egf.console.internal.highWaterMark") || property.equals("org.eclipse.egf.console.internal.lowWaterMark")) {
                this.initLimitOutput();
            } else if (property.equals("org.eclipse.egf.console.internal.debugColor")) {
                newColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.debugColor");
                this._debugStream.setColor(newColor);
                this._debugColor.dispose();
                this._debugColor = newColor;
            } else if (property.equals("org.eclipse.egf.console.internal.errorColor")) {
                newColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.errorColor");
                this._errorStream.setColor(newColor);
                this._errorColor.dispose();
                this._errorColor = newColor;
            } else if (property.equals("org.eclipse.egf.console.internal.informationColor")) {
                newColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.informationColor");
                this._infoStream.setColor(newColor);
                this._infoColor.dispose();
                this._infoColor = newColor;
            } else if (property.equals("org.eclipse.egf.console.internal.warningColor")) {
                newColor = this.createColor(EGFConsolePlugin.getWorkbenchDisplay(), "org.eclipse.egf.console.internal.warningColor");
                this._warningStream.setColor(newColor);
                this._warningColor.dispose();
                this._warningColor = newColor;
            } else if (property.equals("org.eclipse.egf.console.internal.font")) {
                this.setFont(JFaceResources.getFont((String)"org.eclipse.egf.console.internal.font"));
            } else if (property.equals("org.eclipse.egf.console.internal.backgroundColor")) {
                this.setBackground(EGFConsolePlugin.getDefault().getPreferenceColor("org.eclipse.egf.console.internal.backgroundColor"));
            }
        }
        if (property.equals("org.eclipse.egf.console.internal.showOnMessage")) {
            Object value = event.getNewValue();
            this._showOnMessage = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : ((Boolean)value).booleanValue();
        }
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return NLS.bind((String)ConsoleMessages.Console_error, (Object[])new String[]{status.getException().toString()});
        }
        if (status.getSeverity() == 2) {
            return NLS.bind((String)ConsoleMessages.Console_warning, (Object[])new String[]{status.getException().toString()});
        }
        if (status.getSeverity() == 1) {
            return NLS.bind((String)ConsoleMessages.Console_info, (Object[])new String[]{status.getException().toString()});
        }
        return status.getMessage();
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)EGFConsolePlugin.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this._showOnMessage) {
            if (!this._visible) {
                ConsoleFactory.showConsole();
            } else {
                this._consoleManager.showConsoleView((IConsole)this);
            }
        }
    }

    public class MyLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == Console.this) {
                    Console.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == Console.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    Console.this.dispose();
                }
                ++i;
            }
        }
    }
}

