/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.doc.patterns.internal;

import java.util.Iterator;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.emf.common.util.EList;

public class PatternDescriptionHelper {
    private static final String PATTERN_MODEL_IMG_TAG = "<img src=\"../../../org.eclipse.egf.model.edit/icons/full/obj16/PatternModel.gif\" border=\"0\" /> ";
    private static final String PATTERN_LIBRARY_IMG_TAG = "<img src=\"../../../org.eclipse.egf.model.edit/icons/full/obj16/PatternLibrary.gif\" border=\"0\" /> ";
    private static final String UNORDERED_LIST_TAG_START = "<ul>";
    private static final String UNORDERED_LIST_TAG_END = "</ul>";
    private static final String LIST_ITEM_TAG_START = "<li>";
    private static final String LIST_ITEM_TAG_END = "</li>";

    public static String generateDescription(PatternViewpoint patternViewpoint_p) {
        StringBuilder result = new StringBuilder();
        if (patternViewpoint_p == null) {
            return result.toString();
        }
        EList libraries = patternViewpoint_p.getLibraries();
        if (!libraries.isEmpty()) {
            result.append(UNORDERED_LIST_TAG_START);
            for (PatternLibrary currentPatternLibrary : libraries) {
                result.append(PatternDescriptionHelper.generateLibraryDescription(currentPatternLibrary));
            }
            result.append(UNORDERED_LIST_TAG_END);
        }
        return result.toString();
    }

    private static String generateLibraryDescription(PatternLibrary patternLibrary_p) {
        StringBuilder result = new StringBuilder();
        result.append(LIST_ITEM_TAG_START).append(PATTERN_LIBRARY_IMG_TAG);
        result.append(patternLibrary_p.getName());
        Iterator iterator = patternLibrary_p.getPatternElements().iterator();
        result.append(UNORDERED_LIST_TAG_START);
        while (iterator.hasNext()) {
            AbstractPatternElement currentPatternElement = (AbstractPatternElement)iterator.next();
            if (currentPatternElement instanceof PatternLibrary) {
                result.append(PatternDescriptionHelper.generateLibraryDescription((PatternLibrary)currentPatternElement));
                continue;
            }
            if (!(currentPatternElement instanceof PatternModel)) continue;
            result.append(PatternDescriptionHelper.generatePatternDescription((PatternModel)currentPatternElement));
        }
        result.append(UNORDERED_LIST_TAG_END);
        result.append(LIST_ITEM_TAG_END);
        return result.toString();
    }

    private static Object generatePatternDescription(PatternModel patternModel_p) {
        StringBuilder result = new StringBuilder();
        result.append(LIST_ITEM_TAG_START).append(PATTERN_MODEL_IMG_TAG);
        result.append(patternModel_p.getName());
        result.append(LIST_ITEM_TAG_END);
        return result.toString();
    }
}

