/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.emf.reader;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.emf.internal.reader.descriptor.EmfExtensionDescriptor;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.egf.pde.reader.PdeAbstractReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class PdeEmfReader
extends PdeAbstractReader {
    public IDescriptor readEmfExtension(IProject project_p) {
        IDescriptor result = null;
        if (project_p == null) {
            return result;
        }
        IFile pluginFile = EgfPdeActivator.getDefault().getFile(project_p);
        if (pluginFile != null) {
            result = this.readDescriptor(new CreateEmfExtensionDescriptorOperation(pluginFile));
        }
        return result;
    }

    protected class CreateEmfExtensionDescriptorOperation
    extends CreateDescriptorOperation {
        public CreateEmfExtensionDescriptorOperation(IFile modelFile_p) {
            super(modelFile_p);
        }

        protected IDescriptor createDescriptor(IPluginModelBase model_p) {
            IPluginElement[] extensionPluginElements = this.getExtensionWithNodeName(model_p, "org.eclipse.emf.ecore.generated_package", "package");
            if (extensionPluginElements.length == 0) {
                return null;
            }
            GenericDescriptor resultingDescriptors = new GenericDescriptor();
            IPluginElement[] iPluginElementArray = extensionPluginElements;
            int n = extensionPluginElements.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginElement pluginElement = iPluginElementArray[n2];
                EmfExtensionDescriptor descriptor = new EmfExtensionDescriptor();
                String uri = this.getPluginAttributeValue(pluginElement, "uri");
                String genModelUri = this.getPluginAttributeValue(pluginElement, "genModel");
                genModelUri = String.valueOf(this.getModelFile().getProject().getName()) + '/' + genModelUri;
                Couple generatedPackageData = new Couple((Object)uri, (Object)URI.createPlatformResourceURI((String)genModelUri, (boolean)true));
                descriptor.setGeneratedPackage((Couple<String, URI>)generatedPackageData);
                resultingDescriptors.addChild((IDescriptor)descriptor);
                ++n2;
            }
            return resultingDescriptors;
        }
    }
}

