/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.codegen.jet.JETCharDataGenerator;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETConstantDataGenerator;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETMark;

public class JETCompilerExt
extends JETCompiler {
    private Stack rangeStack = new Stack();
    private HashMap jetGenerators2Ranges = new HashMap();
    private HashMap ranges2JetGenerators = new HashMap();
    private HashMap jet2java = new HashMap();
    private HashMap java2jet = new HashMap();
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String METHOD_DECLARATION = "public String generate(Object argument)";
    protected final String STRING_BUFFER_DECLARATION = "    final StringBuffer stringBuffer = new StringBuffer();" + this.NL;

    public JETCompilerExt(String templateURI, InputStream stream) throws JETException {
        super(templateURI, stream, "UTF-8");
    }

    public Range getJETRange(int jetOffset, String fileURI) {
        Iterator it = this.rangeStack.iterator();
        while (it.hasNext()) {
            Range range = (Range)it.next();
            if (range.start > jetOffset || jetOffset >= range.stop || !fileURI.equals(range.fileURI)) continue;
            return range;
        }
        return null;
    }

    public Range getJavaRange(int javaOffset) {
        Iterator it = this.java2jet.keySet().iterator();
        while (it.hasNext()) {
            Range range = (Range)it.next();
            if (range.start > javaOffset || javaOffset >= range.stop) continue;
            return range;
        }
        return null;
    }

    public Range getJavaRange(Range jetRange) {
        return (Range)this.jet2java.get(jetRange);
    }

    public Range getJetRange(Range javaRange) {
        return (Range)this.java2jet.get(javaRange);
    }

    public void handleExpression(JETMark start, JETMark stop, Map attributes) throws JETException {
        char[] chars = this.reader.getChars(start, stop);
        Range jetRange = new Range(start.getCursor(), stop.getCursor() + 2, chars, start.getLocalFile());
        this.rangeStack.push(jetRange);
        super.handleExpression(start, stop, attributes);
    }

    public void handleScriptlet(JETMark start, JETMark stop, Map attributes) throws JETException {
        char[] chars = this.reader.getChars(start, stop);
        Range jetRange = new Range(start.getCursor(), stop.getCursor() + 2, chars, start.getLocalFile());
        this.rangeStack.push(jetRange);
        super.handleScriptlet(start, stop, attributes);
    }

    public void parse() throws JETException {
        this.rangeStack.clear();
        this.jetGenerators2Ranges.clear();
        this.ranges2JetGenerators.clear();
        super.parse();
    }

    public void doAddCharDataGenerator(char[] chars) throws JETException {
        JETConstantDataGenerator gen = null;
        if (this.fUseStaticFinalConstants) {
            gen = (JETConstantDataGenerator)this.constantDictionary.get(chars);
            if (gen == null) {
                JETConstantDataGenerator jetConstantDataGenerator;
                if (this.constantCount == 0L) {
                    chars = this.stripFirstNewLineWithBlanks(chars);
                }
                ++this.constantCount;
                String label = "TEXT_" + this.constantCount;
                gen = jetConstantDataGenerator = new JETConstantDataGenerator(chars, label);
                this.constantDictionary.put(chars, jetConstantDataGenerator);
                this.constants.add(jetConstantDataGenerator);
            }
            this.generators.add(gen);
        } else {
            gen = new JETCharDataGenerator(chars);
            this.generators.add(gen);
        }
        JETMark current = this.reader.mark();
        Range jetRange = new Range(0, chars.length, gen.generate().toCharArray(), current.getLocalFile());
        if (!this.rangeStack.isEmpty()) {
            Range lastInStack = (Range)this.rangeStack.peek();
            int start = lastInStack.stop;
            jetRange = new Range(start, start + chars.length, gen.generate().toCharArray(), current.getLocalFile());
        }
        this.rangeStack.push(jetRange);
        this.jetGenerators2Ranges.put(gen, jetRange);
        this.ranges2JetGenerators.put(jetRange, gen);
    }

    public void addGenerator(JETGenerator gen) throws JETException {
        if (!(gen instanceof JETCharDataGenerator)) {
            Range jetRange = (Range)this.rangeStack.peek();
            this.jetGenerators2Ranges.put(gen, jetRange);
            this.ranges2JetGenerators.put(jetRange, gen);
        }
        super.addGenerator(gen);
    }

    public void generate(OutputStream outputStream) throws JETException {
        super.generate(outputStream);
        this.java2jet.clear();
        this.jet2java.clear();
        int currentGeneratedOffset = this.skeleton.getCompilationUnitContents().indexOf("public String generate(Object argument)") + "public String generate(Object argument)".length();
        StringBuffer decl = new StringBuffer();
        decl.append(String.valueOf(this.NL) + "  {" + this.NL);
        decl.append(this.STRING_BUFFER_DECLARATION);
        currentGeneratedOffset += decl.toString().length();
        Iterator i = this.generators.iterator();
        while (i.hasNext()) {
            JETGenerator jetGenerator = (JETGenerator)i.next();
            Range jetRange = (Range)this.jetGenerators2Ranges.get(jetGenerator);
            String bodyLine = jetGenerator.generate();
            bodyLine = "    " + bodyLine + this.NL;
            String line = jetRange.getGeneratedString();
            int offsetStart = currentGeneratedOffset + bodyLine.indexOf(line);
            int offsetEnd = offsetStart + line.toString().length();
            if (jetRange != null) {
                Range javaRange = new Range(offsetStart, offsetEnd, line.toCharArray(), null);
                this.java2jet.put(javaRange, jetRange);
                this.jet2java.put(jetRange, javaRange);
            }
            currentGeneratedOffset += bodyLine.toString().length();
        }
    }

    public static class Range {
        public int start = -1;
        public int stop = -1;
        private char[] chars;
        private String fileURI;

        public Range(int start, int stop, char[] chars, String fileURI) {
            this.start = start;
            this.stop = stop;
            this.chars = chars;
            this.fileURI = fileURI;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Range) {
                Range other = (Range)obj;
                return this.start == other.start && this.stop == other.stop;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int res = 17;
            res = res * 37 + this.start;
            res = res * 37 + this.stop;
            return res;
        }

        public String toString() {
            return "start : " + this.start + ", stop :" + this.stop + ", chars : " + this.getGeneratedString();
        }

        public String getGeneratedString() {
            return String.valueOf(this.chars);
        }
    }
}

