/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.fc;

import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.workbench.EgfWorkbenchActivator;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractModelElementAction;
import org.eclipse.egf.core.ui.workbench.action.navigator.ValidateElementAction;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFactoryExecutionAction
extends AbstractModelElementAction {
    public AbstractFactoryExecutionAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
        this.setText(Messages.ExecuteFactoryAction_Title);
        this.setToolTipText(Messages.ExecuteFactoryAction_Tooltip);
        this.setImageDescriptor(EgfWorkbenchActivator.getDefault().getImageDescriptor("obj16/execute_factory.gif"));
    }

    protected Wizard getWizardFor(NamedModelElementWithId selectedModelElement_p) {
        return null;
    }

    public void run() {
        boolean readyToExecute = true;
        IPreferenceStore preferenceStore = EgfUiActivator.getDefault().getPreferenceStore();
        boolean validationRequested = preferenceStore.getBoolean("FactoryComponent_Execution_Mode");
        if (validationRequested) {
            ValidateElementAction validateAction = new ValidateElementAction(this.getShell(), this.getSelectionProvider(), this.isReadOnly(), false);
            validateAction.setErrorDialogTitle(Messages.ExecuteFactoryAction_ValidationErrorDialog_Title);
            validateAction.setSelectedElement(this.getModelElement());
            validateAction.run();
            readyToExecute = validateAction.isValid();
        }
        if (readyToExecute) {
            String fcId = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)this.getModelElement()).getId();
            CoreActivator.getDefault().generateFactoryComponent(fcId, null, true);
        }
    }
}

