/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer.delete;

import org.eclipse.core.resources.IFile;
import org.eclipse.egf.common.ui.helper.DialogHelper;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractModelElementAction;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.ActionFactory;

public abstract class DeleteModelElementAction
extends AbstractModelElementAction {
    private boolean _isUserConfirmationRequested = true;

    protected DeleteModelElementAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
        this.setId(ActionFactory.DELETE.getId());
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        ISharedImages sharedImages = this.getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setText(Messages.DeleteAction_Title);
        this.setToolTipText(Messages.DeleteAction_Tooltip);
    }

    public void setUserConfirmationRequested(boolean userConfirmation_p) {
        this._isUserConfirmationRequested = userConfirmation_p;
    }

    public void run() {
        boolean deleteConfirmed = true;
        if (this._isUserConfirmationRequested) {
            Object[] arguments = this.getConfirmDeleteMessage();
            deleteConfirmed = DialogHelper.openDeleteConfirmationDialog((Shell)this.getShell(), (Object[])arguments);
        }
        if (deleteConfirmed) {
            this.doDeleteModelElement();
        }
    }

    protected void doDeleteModelElement() {
        NamedModelElementWithId modelElement = this.getModelElement();
        boolean canDelete = this.closeEditor(modelElement);
        if (canDelete) {
            this.executeDeleteCommand(modelElement);
        }
    }

    private void executeDeleteCommand(NamedModelElementWithId modelElement_p) {
        AdapterFactoryEditingDomain editingDomain = this.getEditingDomain();
        Command command = DeleteCommand.create((EditingDomain)editingDomain, (Object)modelElement_p);
        this.updateLabel(command, editingDomain.getAdapterFactory(), modelElement_p);
        this.executeCommand(editingDomain, command);
    }

    private void updateLabel(Command command_p, AdapterFactory adapterFactory_p, NamedModelElementWithId element_p) {
        String elementText;
        if (command_p == null || adapterFactory_p == null || element_p == null) {
            return;
        }
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory_p.adapt((Notifier)element_p, IItemLabelProvider.class);
        if (labelProvider != null && (elementText = labelProvider.getText((Object)element_p)) != null && elementText.length() > 0) {
            StringBuilder updatedLabel = new StringBuilder(command_p.getLabel()).append(' ').append(element_p.eClass().getName()).append(' ').append(elementText);
            ((AbstractCommand)command_p).setLabel(updatedLabel.toString());
        }
    }

    protected abstract String[] getConfirmDeleteMessage();

    protected Wizard getWizardFor(NamedModelElementWithId modelElement_p) {
        return null;
    }

    protected boolean closeEditor(NamedModelElementWithId modelElement_p) {
        return true;
    }

    protected boolean closeFileEditor(IFile modelElementFile_p, String editorId_p) {
        boolean result = true;
        String modelElementPath = modelElementFile_p.getFullPath().toString();
        IEditorReference[] allOpenMappingEditors = WorkbenchHelper.getAllOpenEditors((String)editorId_p);
        IEditorPart modelElementEditor = null;
        int i = 0;
        while (i < allOpenMappingEditors.length && modelElementEditor == null) {
            IEditorReference currentEditorRefernce = allOpenMappingEditors[i];
            IEditorPart currentEditor = currentEditorRefernce.getEditor(false);
            IEditorInput editorInput = currentEditor.getEditorInput();
            URI resourceURI = EditUIUtil.getURI((IEditorInput)editorInput);
            String currentEditorInputPath = resourceURI.toPlatformString(true);
            if (modelElementPath.equals(currentEditorInputPath)) {
                modelElementEditor = currentEditor;
            }
            ++i;
        }
        if (modelElementEditor != null) {
            result = WorkbenchHelper.closeEditor(modelElementEditor, (boolean)false);
        }
        return result;
    }
}

