/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.internal.validators;

import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.ClassLoadingHelper;
import org.eclipse.egf.common.ui.internal.validators.Messages;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassValidator
extends NotEmptyStringValidator {
    private ClassLoader _classLoader;
    private Bundle _bundle;
    private Class<?> _expectedClassType;

    public JavaClassValidator(ClassLoader classLoader_p, Bundle bundle_p, Class<?> expectedClassType_p) {
        super(Messages.JavaClassValidator_Error_Message_EMPTY_CLASS);
        this._classLoader = classLoader_p;
        this._bundle = bundle_p;
        this._expectedClassType = expectedClassType_p;
    }

    @Override
    public String isValid(Object value_p) {
        String errorMessage = super.isValid(value_p);
        if (errorMessage == null) {
            Object object = null;
            if (this._classLoader != null) {
                object = ClassLoadingHelper.instantiate((String)((String)value_p), (ClassLoader)this._classLoader);
            } else if (this._bundle != null) {
                object = BundleHelper.instantiate((String)((String)value_p), (Bundle)this._bundle);
            }
            if (object == null) {
                errorMessage = String.valueOf(Messages.JavaClassValidator_Error_Message_UNABLE_TO_LOAD) + value_p;
            } else if (!this._expectedClassType.isInstance(object)) {
                errorMessage = value_p + Messages.JavaClassValidator_Error_Message_INSTANCE_OF + this._expectedClassType.getName();
            }
        }
        return errorMessage;
    }

    public void setExpectedClassType(Class<?> expectedClassType_p) {
        this._expectedClassType = expectedClassType_p;
    }
}

