/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.descriptor.pattern.helper;

import java.util.List;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;

public class PatternDescriptorStrategy {
    public void iterateThroughPatternExtensionDescriptor(IPatternDescriptorHandler handler_p, IDescriptor descriptor_p) {
        if (handler_p == null || descriptor_p == null) {
            return;
        }
        this.handlePatternExtensionDescriptor(handler_p, descriptor_p, null);
    }

    protected void handlePatternExtensionDescriptor(IPatternDescriptorHandler handler_p, IDescriptor descriptor_p, String idPrefix_p) {
        Object descriptorType = descriptor_p.getValue("patternExtType");
        List<IDescriptor> children = descriptor_p.getChildren();
        String currentId = (String)descriptor_p.getValue("id");
        StringBuilder idPrefix = new StringBuilder();
        if ("library".equals(descriptorType)) {
            if (idPrefix_p == null || idPrefix_p.trim().length() == 0) {
                idPrefix.append(currentId);
            } else {
                idPrefix.append(idPrefix_p).append('/').append(currentId);
            }
            handler_p.handleLibraryDescriptor(descriptor_p, idPrefix.toString());
        } else if ("pattern".equals(descriptorType)) {
            children = null;
            idPrefix.append(idPrefix_p).append('/').append(currentId);
            handler_p.handlePatternDescriptor(descriptor_p, idPrefix.toString());
        } else {
            handler_p.handleDescriptor(descriptor_p);
        }
        if (children != null && this.stopSearch(descriptor_p)) {
            children = null;
        }
        if (children != null) {
            for (IDescriptor descriptor : children) {
                this.handlePatternExtensionDescriptor(handler_p, descriptor, idPrefix.toString());
            }
        }
    }

    protected boolean stopSearch(IDescriptor parentDescriptor_p) {
        return false;
    }

    public static void retainRootOnly(GenericDescriptor rootDescriptor_p, IDescriptor childContainer_p) {
        if (childContainer_p == null) {
            return;
        }
        if (childContainer_p.getValue("patternExtType") == null) {
            List<IDescriptor> children = childContainer_p.getChildren();
            for (IDescriptor descriptor : children) {
                PatternDescriptorStrategy.retainRootOnly(rootDescriptor_p, descriptor);
            }
        } else {
            rootDescriptor_p.addChild(childContainer_p);
        }
    }

    public static String getDescriptorFullId(IDescriptor descriptor_p) {
        String result = null;
        if (descriptor_p == null) {
            return result;
        }
        result = "";
        IDescriptor currentParent = descriptor_p;
        while (currentParent != null) {
            String parentId = (String)currentParent.getValue("id");
            if (parentId != null && parentId.trim().length() > 0) {
                result = result.length() > 0 ? parentId + '/' + result : parentId;
            }
            currentParent = currentParent.getParent();
        }
        return result;
    }
}

