/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.util;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.model.AbstractFactoryComponentFactory;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.AbstractViewpoint;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.Factory;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.MappingModel;
import org.eclipse.egf.model.MappingViewpoint;
import org.eclipse.egf.model.ModelActivator;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.Specification;
import org.eclipse.egf.model.TaskFactoryHolder;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.ViewpointType;
import org.eclipse.egf.model.validation.IDelegatedValidator;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelValidator
extends EObjectValidator {
    private static final Logger __logger = Logger.getLogger((String)ModelValidator.class.getPackage().getName());
    private static final String EXTENSION_POINT_SHORT_ID_DELEGATED_VALIDATOR = "delegatedValidator";
    public static final ModelValidator INSTANCE = new ModelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return ModelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNamedModelElementWithId((NamedModelElementWithId)value, diagnostics, context);
            }
            case 1: {
                return this.validateFactoryComponent((FactoryComponent)value, diagnostics, context);
            }
            case 2: {
                return this.validateProductionPlan((ProductionPlan)value, diagnostics, context);
            }
            case 3: {
                return this.validateFactoryComponentInvocation((FactoryComponentInvocation)value, diagnostics, context);
            }
            case 4: {
                return this.validateDomain((Domain)value, diagnostics, context);
            }
            case 5: {
                return this.validateSpecification((Specification)value, diagnostics, context);
            }
            case 6: {
                return this.validateAbstractViewpoint((AbstractViewpoint)value, diagnostics, context);
            }
            case 7: {
                return this.validateContract((Contract)value, diagnostics, context);
            }
            case 8: {
                return this.validateContractElement((ContractElement)value, diagnostics, context);
            }
            case 9: {
                return this.validateContractElementReference((ContractElementReference)value, diagnostics, context);
            }
            case 10: {
                return this.validateType((Type)value, diagnostics, context);
            }
            case 11: {
                return this.validatePatternViewpoint((PatternViewpoint)value, diagnostics, context);
            }
            case 12: {
                return this.validateAbstractPatternElement((AbstractPatternElement)value, diagnostics, context);
            }
            case 13: {
                return this.validatePatternLibrary((PatternLibrary)value, diagnostics, context);
            }
            case 14: {
                return this.validatePatternModel((PatternModel)value, diagnostics, context);
            }
            case 15: {
                return this.validateFactory((Factory)value, diagnostics, context);
            }
            case 16: {
                return this.validateAbstractFactoryComponentFactory((AbstractFactoryComponentFactory)value, diagnostics, context);
            }
            case 17: {
                return this.validateContext((Context)value, diagnostics, context);
            }
            case 18: {
                return this.validateContextElement((ContextElement)value, diagnostics, context);
            }
            case 19: {
                return this.validateTaskFactoryHolder((TaskFactoryHolder)value, diagnostics, context);
            }
            case 20: {
                return this.validateMappingViewpoint((MappingViewpoint)value, diagnostics, context);
            }
            case 21: {
                return this.validateMappingModel((MappingModel)value, diagnostics, context);
            }
            case 22: {
                return this.validateViewpointType((ViewpointType)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNamedModelElementWithId(NamedModelElementWithId namedModelElementWithId, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(namedModelElementWithId, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedModelElementWithId, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(namedModelElementWithId, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedModelElementWithId_overall(NamedModelElementWithId namedModelElementWithId, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean valid = true;
        IDelegatedValidator delegatedValidator = this.getDelegatedValidator();
        if (delegatedValidator != null) {
            valid = delegatedValidator.validate(namedModelElementWithId, diagnostics, context);
        } else {
            StringBuilder loggerMessage = new StringBuilder("ModelValidator.validateNamedModelElementWithId_overall(..) _ ");
            loggerMessage.append("Delegated validator implementor not found.");
            __logger.warn((Object)loggerMessage.toString());
        }
        return valid;
    }

    private IDelegatedValidator getDelegatedValidator() {
        Object instantiatedClass;
        IDelegatedValidator delegatedValidator = null;
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)ModelActivator.getDefault().getPluginID(), (String)EXTENSION_POINT_SHORT_ID_DELEGATED_VALIDATOR);
        if (configurationElements != null && configurationElements.length > 0 && (instantiatedClass = ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class")) instanceof IDelegatedValidator) {
            delegatedValidator = (IDelegatedValidator)instantiatedClass;
        }
        return delegatedValidator;
    }

    public boolean validateFactoryComponent(FactoryComponent factoryComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(factoryComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validateDomain(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(domain, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(domain, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(domain, diagnostics, context);
        }
        return result;
    }

    public boolean validateSpecification(Specification specification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(specification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(specification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(specification, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractViewpoint(AbstractViewpoint abstractViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(abstractViewpoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(abstractViewpoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateContract(Contract contract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(contract, diagnostics, context);
        }
        return result;
    }

    public boolean validateContractElement(ContractElement contractElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contractElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contractElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(contractElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateContractElementReference(ContractElementReference contractElementReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contractElementReference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contractElementReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(contractElementReference, diagnostics, context);
        }
        return result;
    }

    public boolean validateType(Type type, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(type, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(type, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(type, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternViewpoint(PatternViewpoint patternViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(patternViewpoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(patternViewpoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractPatternElement(AbstractPatternElement abstractPatternElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(abstractPatternElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractPatternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(abstractPatternElement, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternLibrary(PatternLibrary patternLibrary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(patternLibrary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(patternLibrary, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternModel(PatternModel patternModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(patternModel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(patternModel, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactory(Factory factory, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factory, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(factory, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractFactoryComponentFactory(AbstractFactoryComponentFactory abstractFactoryComponentFactory, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(abstractFactoryComponentFactory, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractFactoryComponentFactory, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(abstractFactoryComponentFactory, diagnostics, context);
        }
        return result;
    }

    public boolean validateProductionPlan(ProductionPlan productionPlan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(productionPlan, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(productionPlan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(productionPlan, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactoryComponentInvocation(FactoryComponentInvocation factoryComponentInvocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponentInvocation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponentInvocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(factoryComponentInvocation, diagnostics, context);
        }
        return result;
    }

    public boolean validateContext(Context context, DiagnosticChain diagnostics, Map<Object, Object> theContext) {
        boolean result = this.validate_EveryMultiplicityConforms(context, diagnostics, theContext);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(context, diagnostics, theContext);
        }
        return result;
    }

    public boolean validateContextElement(ContextElement contextElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(contextElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contextElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(contextElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateTaskFactoryHolder(TaskFactoryHolder taskFactoryHolder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(taskFactoryHolder, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(taskFactoryHolder, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(taskFactoryHolder, diagnostics, context);
        }
        return result;
    }

    public boolean validateMappingViewpoint(MappingViewpoint mappingViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(mappingViewpoint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mappingViewpoint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(mappingViewpoint, diagnostics, context);
        }
        return result;
    }

    public boolean validateMappingModel(MappingModel mappingModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(mappingModel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mappingModel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedModelElementWithId_overall(mappingModel, diagnostics, context);
        }
        return result;
    }

    public boolean validateViewpointType(ViewpointType viewpointType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

