/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.contract.type;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.ClassLoadingHelper;
import org.eclipse.egf.model.contract.type.AbstractTypeHolder;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassTypeHolder
extends AbstractTypeHolder {
    private static final Logger __logger = Logger.getLogger((String)ClassTypeHolder.class.getPackage().getName());
    private String _pluginId;
    private ClassLoader _classLoader;

    @Override
    public void setPluginId(String pluginId_p) {
        this._pluginId = pluginId_p;
    }

    public void setClassLoader(ClassLoader classLoader_p) {
        this._classLoader = classLoader_p;
    }

    @Override
    public Object getValue(String value_p) {
        Object result = null;
        if (value_p == null) {
            return result;
        }
        result = this.loadClass(value_p);
        return result;
    }

    private Object loadClass(String className_p) {
        Object result = null;
        Class class_ = null;
        if (this._pluginId != null) {
            class_ = this.loadClassFromRuntimePlatform(className_p);
        } else if (this._classLoader != null) {
            class_ = ClassLoadingHelper.loadClass((String)className_p, (ClassLoader)this._classLoader);
        }
        if (class_ != null) {
            try {
                result = class_.newInstance();
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("ClassTypeHolder.loadClass(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return result;
    }

    private Class<?> loadClassFromRuntimePlatform(String className_p) {
        Class result = null;
        Bundle bundle = Platform.getBundle((String)this._pluginId);
        if (bundle != null) {
            try {
                result = bundle.loadClass(className_p);
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("ClassTypeHolder.loadClassFromRuntimePlatform(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return result;
    }

    @Override
    public boolean isJava() {
        return true;
    }

    @Override
    public boolean isValid(String value_p) {
        boolean result;
        Object class_ = this.getValue(value_p);
        boolean bl = result = class_ != null;
        if (result) {
            result = this.isValidType(class_);
        }
        return result;
    }

    protected boolean isValidType(Object classInstance_p) {
        boolean result = false;
        Class<?> expectedType = this.getExpectedType();
        if (expectedType.isInstance(classInstance_p)) {
            result = true;
        }
        return result;
    }

    public abstract Class<?> getExpectedType();
}

