/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation;

import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternDetails;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.util.DisplayHelper;
import org.eclipse.egf.pattern.ui.internal.editor.DefaultPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodActionHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.PatternCodeActionParameterWizard;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.PatternCodeActionTypeSelectionPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MethodPatternCodeDetailsViewer
extends AbstractPatternDetails {
    private MethodPatternCodeActionHandler _handler;
    private AbstractPatternPage _page;
    private Text _actionParameterText;
    private DisplayHelper _displayHelper;
    private String _actionType;

    public MethodPatternCodeDetailsViewer(IFormPart masterPart_p, AbstractPatternPage patternPage_p) {
        super(masterPart_p);
        this._page = patternPage_p;
    }

    protected void doCreateContents(FormToolkit toolkit_p, Composite parent_p, Object initialContent_p) {
        MethodActionHandler actionHandler = (MethodActionHandler)initialContent_p;
        Couple<String, String> action = actionHandler.getAction();
        this._actionType = (String)action.getKey();
        FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        Couple actionCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)3, (boolean)false);
        ((Section)actionCouple.getKey()).setText(Messages.MethodPatternCodeDetailsViewer_ActionPropertiesSectionText);
        Composite actionComposite = (Composite)actionCouple.getValue();
        Couple actionName = FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)actionComposite, (String)Messages.MethodPatternCodeDetailsViewer_ActionPropertiesNameLabel, (String)PatternCodeActionTypeSelectionPage.getActionTypeDisplayableText(this._actionType), (boolean)false);
        GridData actionNameTextData = (GridData)((Text)actionName.getValue()).getLayoutData();
        actionNameTextData.horizontalSpan = 2;
        this._handler = new MethodPatternCodeActionHandler(this._page);
        Couple actionParameter = FormHelper.createLabelTextAndButton((FormToolkit)toolkit_p, (Composite)actionComposite, (String)Messages.MethodPatternCodeDetailsViewer_ActionPropertiesParameterLabel, (String)Messages.MethodPatternCodeDetailsViewer_ActionPropertiesParameterButtonLabel, (SelectionListener)this._handler);
        this._actionParameterText = (Text)actionParameter.getKey();
        this._actionParameterText.setEditable(false);
        String actionParameterValue = (String)action.getValue();
        if (actionParameterValue == null) {
            actionParameterValue = "";
        }
        this.setParameterValue(actionParameterValue);
    }

    protected void setParameterValue(String actionParameterValue_p) {
        if (this._displayHelper == null) {
            this._displayHelper = new DisplayHelper();
        }
        if ("PATTERN".equals(this._actionType)) {
            this._actionParameterText.setText(this._displayHelper.getPatternOrLibraryFullName(actionParameterValue_p));
        } else {
            this._actionParameterText.setText(actionParameterValue_p);
        }
    }

    protected class MethodPatternCodeActionHandler
    extends DefaultContentHandler
    implements SelectionListener {
        public MethodPatternCodeActionHandler(AbstractPatternPage page_p) {
            super(null, page_p);
        }

        public void widgetDefaultSelected(SelectionEvent se_p) {
        }

        public void widgetSelected(SelectionEvent se_p) {
            MethodActionHandler patternCodeActionHandler = (MethodActionHandler)MethodPatternCodeDetailsViewer.this.getInitialContent();
            Couple<String, String> patternCodeAction = patternCodeActionHandler.getAction();
            String oldParameterValue = (String)patternCodeAction.getValue();
            Couple temporaryAction = patternCodeAction.clone();
            WizardDialog wizardDialog = new WizardDialog(MethodPatternCodeDetailsViewer.this._page.getSite().getShell(), (IWizard)new PatternCodeActionParameterWizard(MethodPatternCodeDetailsViewer.this._page.getPatternData(), (Couple<String, String>)temporaryAction));
            int returnCode = wizardDialog.open();
            if (returnCode == 0) {
                String newParameterValue = (String)temporaryAction.getValue();
                patternCodeAction.setValue((Object)newParameterValue);
                MethodPatternCodeDetailsViewer.this.setParameterValue(newParameterValue);
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(4, patternCodeActionHandler, oldParameterValue, newParameterValue);
                this.getPage().getEditor().sendNotification(notification);
                this.notifyModification();
            }
        }
    }
}

