/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page;

import org.eclipse.egf.common.ui.toolkit.viewers.AbstractStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternPageContentProvider
extends AbstractStructuredContentProvider {
    private volatile boolean _isDisposed;
    private Object _initialInput;
    private Viewer _viewer;

    public void dispose() {
        this._isDisposed = true;
        this.doDispose();
    }

    protected Viewer getViewer() {
        return this._viewer;
    }

    protected Object getInitialInput() {
        return this._initialInput;
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        if (oldInput_p != null && newInput_p != null && newInput_p != oldInput_p) {
            this._initialInput = newInput_p;
        }
        super.inputChanged(viewer_p, oldInput_p, newInput_p);
    }

    protected void handleElementAdded(Viewer viewer_p, Object addedElements_p) {
        if (this.isDisposed()) {
            return;
        }
        if (this._initialInput == null) {
            this._initialInput = addedElements_p;
        } else {
            this.doHandleElementsAdded(addedElements_p);
        }
    }

    protected abstract void doHandleElementsAdded(Object var1);

    protected void handleElementRemoved(Viewer viewer_p, Object removedElements_p) {
        if (this.isDisposed() || this._initialInput == removedElements_p) {
            return;
        }
        this.doHandleElementsRemoved(removedElements_p);
    }

    protected abstract void doHandleElementsRemoved(Object var1);

    protected void handleElementUpdated(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        if (this.isDisposed()) {
            return;
        }
        this.doHandleElementUpdated(oldInput_p, newInput_p);
    }

    protected abstract void doHandleElementUpdated(Object var1, Object var2);

    protected void handleViewer(Viewer viewer_p) {
        if (this._viewer == null) {
            this._viewer = viewer_p;
        }
    }

    protected Object getElement(Object elements_p, Class<?> elementType_p) {
        Object result = null;
        if (elementType_p == null) {
            return result;
        }
        if (elementType_p.isInstance(elements_p)) {
            result = elements_p;
        } else if (elements_p instanceof Object[]) {
            Object[] results = (Object[])elements_p;
            int i = 0;
            while (i < results.length && result == null) {
                result = this.getElement(results[i], elementType_p);
                ++i;
            }
        }
        return result;
    }

    protected boolean isDisposed() {
        return this._isDisposed;
    }

    protected abstract void doDispose();
}

