/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.ui.viewers.DefaultTreeNode;
import org.eclipse.egf.common.ui.viewers.ITreeNode;
import org.eclipse.egf.model.provider.FactoryComponentEditPlugin;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationListener;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.IParameterHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodHelper;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PatternEditorContentOutlinePage
extends ContentOutlinePage
implements IDoubleClickListener,
IPatternModificationListener {
    private PatternHandler.PatternData _patternData;
    private boolean _isEditable;

    public PatternEditorContentOutlinePage(PatternHandler.PatternData patternData_p, boolean patternIsEditable_p) {
        this._patternData = patternData_p;
        this._isEditable = patternIsEditable_p;
    }

    public void createControl(Composite parent_p) {
        super.createControl(parent_p);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.setSorter((ViewerSorter)new OutlineViewerSorter());
        viewer.setInput((Object)new RootNode());
    }

    public void dispose() {
        super.dispose();
        this.getSite().setSelectionProvider(null);
    }

    public void doubleClick(DoubleClickEvent event_p) {
        IStructuredSelection selection = (IStructuredSelection)event_p.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof InternalMethodHandler) {
            InternalMethodHelper.openMethodContent(this._patternData, (InternalMethodHandler)selectedElement, this._isEditable);
        }
    }

    protected PatternHandler.PatternData getPatternData() {
        return this._patternData;
    }

    public void notifyChanged(IPatternModificationNotification notification_p) {
        int type = notification_p.getEventType();
        switch (type) {
            case 3: 
            case 4: {
                Object notifier = notification_p.getNotifier();
                this.elementModified(notifier);
                break;
            }
            case 1: {
                Object newValue = notification_p.getNewValue();
                this.elementAdded(newValue);
                break;
            }
            case 2: {
                Object oldValue = notification_p.getOldValue();
                this.elementRemoved(oldValue);
                break;
            }
            case 5: {
                this.getPatternDataNode().clear();
                this.getTreeViewer().refresh();
                break;
            }
        }
    }

    protected void elementModified(Object element_p) {
        PatternDataNode patternDataNode = this.getPatternDataNode();
        ITreeNode elementToRefresh = patternDataNode.getNode(element_p);
        if (elementToRefresh != null) {
            this.getTreeViewer().update((Object)elementToRefresh, null);
        }
    }

    protected void elementAdded(Object newElement_p) {
        PatternDataNode patternDataNode = this.getPatternDataNode();
        ITreeNode elementToAdd = patternDataNode.addNode(newElement_p);
        if (elementToAdd != null) {
            this.getTreeViewer().add((Object)patternDataNode, (Object)elementToAdd);
        }
    }

    protected void elementRemoved(Object oldElement_p) {
        PatternDataNode patternDataNode = this.getPatternDataNode();
        ITreeNode elementToRemove = patternDataNode.removeNode(oldElement_p);
        if (elementToRemove != null) {
            this.getTreeViewer().remove((Object)patternDataNode, new Object[]{elementToRemove});
        }
    }

    protected PatternDataNode getPatternDataNode() {
        ITreeNode firstChild = ((ITreeNode)this.getTreeViewer().getInput()).getChildren()[0];
        return (PatternDataNode)firstChild;
    }

    protected class OutlineContentProvider
    extends AbstractPatternPageContentProvider
    implements ITreeContentProvider {
        protected OutlineContentProvider() {
        }

        protected void doDispose() {
        }

        protected TreeViewer getViewer() {
            return (TreeViewer)super.getViewer();
        }

        protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
            this.getViewer().update(newInput_p, null);
        }

        protected void doHandleElementsAdded(Object addedElements_p) {
        }

        protected void doHandleElementsRemoved(Object removedElements_p) {
        }

        public Object[] getElements(Object inputElement_p) {
            return this.getChildren(inputElement_p);
        }

        public Object[] getChildren(Object parentElement_p) {
            Object[] result = null;
            if (parentElement_p instanceof ITreeNode) {
                result = ((ITreeNode)parentElement_p).getChildren();
            }
            this.getViewer().setAutoExpandLevel(-1);
            return result;
        }

        public Object getParent(Object element_p) {
            ITreeNode parent = null;
            if (element_p instanceof ITreeNode) {
                parent = ((ITreeNode)element_p).getParent();
            }
            return parent;
        }

        public boolean hasChildren(Object element_p) {
            boolean result = false;
            if (element_p instanceof ITreeNode) {
                result = ((ITreeNode)element_p).hasChildren();
            }
            return result;
        }
    }

    protected class OutlineLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private static final String INHERITED_PARAMETER_PREFIX = "({0}->) {1}";

        protected OutlineLabelProvider() {
        }

        public Image getImage(Object element_p) {
            Image result = null;
            if (element_p instanceof PatternDataNode) {
                result = ExtendedImageRegistry.INSTANCE.getImage(FactoryComponentEditPlugin.INSTANCE.getImage("full/obj16/PatternModel"));
            } else {
                ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
                if (element_p instanceof PatternMethodNode) {
                    result = imageRegistry.get("org.eclipse.jdt.ui.methpro_obj.gif");
                } else if (element_p instanceof PatternParameterNode) {
                    result = imageRegistry.get("org.eclipse.jdt.ui.field_protected_obj.gif");
                }
            }
            return this.decorateImage(result, element_p);
        }

        public String getText(Object element_p) {
            return this.decorateText(super.getText(element_p), element_p);
        }

        public Image decorateImage(Image image_p, Object element_p) {
            int flag = this.computeFlag(element_p);
            ImageDescriptor baseImage = ImageDescriptor.createFromImage((Image)image_p);
            return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, flag, JavaElementImageProvider.BIG_SIZE));
        }

        protected int computeFlag(Object element_p) {
            int flag = 0;
            if (element_p instanceof PatternDataNode) {
                if (PatternEditorContentOutlinePage.this.getPatternData().getParentPattern() != null) {
                    flag |= 0x100;
                }
            } else if (element_p instanceof PatternMethodNode) {
                if (((PatternMethodNode)element_p).isOverriding()) {
                    flag |= 0x80;
                }
            } else if (element_p instanceof PatternParameterNode && ((PatternParameterNode)element_p).isInherited()) {
                flag |= 0x100;
            }
            return flag;
        }

        public String decorateText(String text_p, Object element_p) {
            PatternParameterNode node;
            String result = text_p;
            if (element_p instanceof PatternParameterNode && (node = (PatternParameterNode)element_p).isInherited()) {
                result = StringHelper.formatMessage((String)INHERITED_PARAMETER_PREFIX, (Object[])new Object[]{node.getDefiningPatternName(), result});
            }
            return result;
        }
    }

    protected class OutlineViewerSorter
    extends ViewerSorter {
        protected OutlineViewerSorter() {
        }

        public int compare(Viewer viewer_p, Object e1_p, Object e2_p) {
            int result = 0;
            if (e1_p instanceof ITreeNode && e2_p instanceof ITreeNode) {
                result = ((ITreeNode)e1_p).comparisonPriority() - ((ITreeNode)e2_p).comparisonPriority();
            }
            if (result == 0) {
                result = super.compare(viewer_p, e1_p, e2_p);
            }
            return result;
        }
    }

    public class PatternDataNode
    extends DefaultTreeNode {
        private List<ITreeNode> _children;
        private InternalMethodHelper.IInternalMethodHandlerFactory _methodHandlerFactory;

        protected PatternDataNode(ITreeNode parent_p) {
            super(parent_p);
        }

        protected void clear() {
            this._children.clear();
            this._children = null;
        }

        public boolean isHandling(Object element_p) {
            return element_p instanceof PatternHandler.PatternData;
        }

        public ITreeNode[] getChildren() {
            if (this._children == null) {
                if (this._methodHandlerFactory == null) {
                    this._methodHandlerFactory = new InternalMethodHelper.IInternalMethodHandlerFactory(){

                        public InternalMethodHandler createNewHandler(EOperation method_p) {
                            return new PatternMethodNode(method_p, (ITreeNode)PatternDataNode.this);
                        }
                    };
                }
                InternalMethodHandler[] internalMethods = InternalMethodHelper.getInternalMethodsFromInput(PatternEditorContentOutlinePage.this.getPatternData(), this._methodHandlerFactory);
                this._children = new ArrayList<ITreeNode>(internalMethods.length);
                InternalMethodHandler[] internalMethodHandlerArray = internalMethods;
                int n = internalMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalMethodHandler handler = internalMethodHandlerArray[n2];
                    this._children.add((ITreeNode)handler);
                    ++n2;
                }
                for (ParameterRelation parameter : PatternEditorContentOutlinePage.this.getPatternData().getAllParameters()) {
                    this._children.add(this.createNewNode(parameter));
                }
            }
            return this._children.toArray(new ITreeNode[this._children.size()]);
        }

        protected ITreeNode createNewNode(Object element_p) {
            Object result = null;
            if (element_p instanceof EOperation) {
                result = (ITreeNode)this._methodHandlerFactory.createNewHandler((EOperation)element_p);
            } else if (element_p instanceof ParameterRelation) {
                result = new PatternParameterNode((ParameterRelation)element_p, (ITreeNode)this);
            }
            return result;
        }

        protected ITreeNode addNode(Object element_p) {
            if (this.getNode(element_p) != null) {
                return null;
            }
            ITreeNode newNode = this.createNewNode(element_p);
            if (newNode != null) {
                this._children.add(newNode);
            }
            return newNode;
        }

        protected ITreeNode removeNode(Object element_p) {
            ITreeNode nodeToRemove = this.getNode(element_p);
            if (nodeToRemove != null) {
                this._children.remove(nodeToRemove);
            }
            return nodeToRemove;
        }

        protected ITreeNode getNode(Object element_p) {
            ITreeNode result = null;
            if (this._children == null) {
                return result;
            }
            for (ITreeNode treeNode : this._children) {
                if (!treeNode.isHandling(element_p)) continue;
                result = treeNode;
                break;
            }
            return result;
        }

        public boolean hasChildren() {
            return true;
        }

        public String toString() {
            return PatternEditorContentOutlinePage.this.getPatternData().getPatternLogicalName();
        }
    }

    protected class PatternMethodNode
    extends InternalMethodHandler
    implements ITreeNode {
        private ITreeNode _parent;

        public PatternMethodNode(EOperation method_p, ITreeNode parent_p) {
            super(method_p, PatternEditorContentOutlinePage.this.getPatternData());
            this._parent = parent_p;
        }

        public ITreeNode[] getChildren() {
            return null;
        }

        public ITreeNode getParent() {
            return this._parent;
        }

        public boolean hasChildren() {
            return false;
        }

        public boolean isHandling(Object element_p) {
            return element_p instanceof EOperation && this.isHandlerFor((EOperation)element_p);
        }

        public int comparisonPriority() {
            return 2;
        }
    }

    protected class PatternParameterNode
    extends DefaultTreeNode
    implements IParameterHandler {
        private ParameterRelation _parameterRelation;

        protected PatternParameterNode(ParameterRelation parameter_p, ITreeNode parent_p) {
            super(parent_p);
            this._parameterRelation = parameter_p;
        }

        public ParameterRelation getParameter() {
            return this._parameterRelation;
        }

        public boolean isHandling(Object element_p) {
            return element_p == this._parameterRelation;
        }

        public boolean isInherited() {
            return !PatternEditorContentOutlinePage.this.getPatternData().getPattern().equals(this._parameterRelation.eContainer());
        }

        protected String getDefiningPatternName() {
            return ((Pattern)this._parameterRelation.eContainer()).getName();
        }

        public boolean hasChildren() {
            return false;
        }

        public int comparisonPriority() {
            if (this.isInherited()) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return String.valueOf(this._parameterRelation.getName()) + ' ' + ':' + ' ' + this._parameterRelation.getType().getName();
        }
    }

    protected class RootNode
    extends DefaultTreeNode {
        private ITreeNode[] _children;

        protected RootNode() {
            super(null);
            this._children = new ITreeNode[]{new PatternDataNode((ITreeNode)this)};
        }

        public ITreeNode[] getChildren() {
            return this._children;
        }

        public boolean hasChildren() {
            return true;
        }
    }
}

