/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor;

import org.apache.log4j.Logger;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class PatternEditorInput
implements IEditorInput {
    private static final Logger __logger = Logger.getLogger((String)PatternEditorInput.class.getPackage().getName());
    private PatternHandler _patternHandler;
    private PatternHandler.PatternData _patternData;
    private PatternModel _patternModel;
    private boolean _dirty;

    public PatternEditorInput(String fcId_p, PatternModel patternModel_p, boolean editable_p) {
        this.initialize(fcId_p, patternModel_p, editable_p);
    }

    protected void initialize(String fcId_p, PatternModel patternModel_p, boolean editable_p) {
        if (this._patternHandler == null) {
            this._patternHandler = new PatternHandler(editable_p);
        }
        this._patternModel = patternModel_p;
        try {
            this._patternData = this._patternHandler.load(patternModel_p.getPath());
            if (editable_p) {
                if (this._patternData.getPatternLogicalName() == null || this._patternData.getPatternLogicalName().trim().length() == 0) {
                    this._patternData.getPattern().setLogicalName(patternModel_p.getName());
                    this._patternData.setPatternLogicalName(patternModel_p.getName());
                    this._dirty = true;
                } else if ((this._patternModel.getName() == null || this._patternModel.getName().trim().length() == 0) && this._patternData.getPatternLogicalName() != null && this._patternData.getPatternLogicalName().trim().length() > 0) {
                    this._dirty = true;
                }
            }
        }
        catch (Exception exception) {
            try {
                this._patternData = this._patternHandler.createPattern(fcId_p, patternModel_p);
            }
            catch (Exception exception_p1) {
                this._patternData = null;
                StringBuilder loggerMessage = new StringBuilder("PatternEditorInput.initialize(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p1);
            }
        }
    }

    public String getName() {
        return this._patternData.getPatternName();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public Object getAdapter(Class adapter_p) {
        PatternHandler.PatternData result = null;
        if (adapter_p == PatternHandler.PatternData.class) {
            try {
                result = this._patternData;
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("PatternEditorInput.getAdapter(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        } else if (adapter_p == PatternModel.class) {
            result = this._patternModel;
        } else if (adapter_p == PatternHandler.class) {
            result = this._patternHandler;
        }
        return result;
    }

    public boolean exists() {
        return false;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

