/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.internal;

import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.manifest.command.ManifestChangeCommandFactory;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class FactoryComponentGeneratorHelper {
    private static final Logger __logger = Logger.getLogger((String)FactoryComponentGeneratorHelper.class.getPackage().getName());

    public static void addGeneratedSourceFolderIn(String pluginId_p, boolean updateBuildProperties_p) {
        IProject project = ProjectHelper.getProject((String)pluginId_p);
        boolean isCreated = FactoryComponentGeneratorHelper.createGeneratedSourceFolder(project);
        if (isCreated && updateBuildProperties_p) {
            WorkspaceBuildModel buildModel = FactoryComponentGeneratorHelper.getBuildModel(project);
            FactoryComponentGeneratorHelper.addGeneratedSourceFolderInLibrarySources((IBuildModel)buildModel, null);
            buildModel.save();
        }
    }

    public static boolean createGeneratedSourceFolder(IProject project_p) {
        return ProjectHelper.createSourceFolder((String)"generated", (IProject)project_p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addFolderIn(String pluginId_p, String folderName_p, boolean updateBuildProperties_p, IProgressMonitor monitor_p) {
        IProject project = ProjectHelper.getProject((String)pluginId_p);
        IFolder folder = ProjectHelper.createFolder((String)folderName_p, (IProject)project, (IProgressMonitor)monitor_p);
        if (folder != null && updateBuildProperties_p) {
            WorkspaceBuildModel buildModel = FactoryComponentGeneratorHelper.getBuildModel(project);
            FactoryComponentGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, String.valueOf(folderName_p) + '/');
            buildModel.save();
        }
    }

    public static void addGeneratedSourceFolderInLibrarySources(IBuildModel buildModel, String entryName_p) {
        if (buildModel == null) {
            return;
        }
        String entryName = entryName_p == null ? String.valueOf('.') : entryName_p;
        IBuild build = buildModel.getBuild();
        IBuildEntry sourceEntry = build.getEntry("source." + entryName);
        if (sourceEntry != null) {
            try {
                sourceEntry.addToken(new Path("generated").addTrailingSeparator().toString());
            }
            catch (CoreException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("FactoryComponentGeneratorHelper.createGeneratedSourceFolderIn(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
    }

    public static void addEntryInBinaryBuild(IBuildModel buildModel_p, String entryName_p) {
        IBuild build = buildModel_p.getBuild();
        IBuildEntry binEntry = build.getEntry("bin.includes");
        if (binEntry != null) {
            try {
                if (!binEntry.contains(entryName_p)) {
                    binEntry.addToken(entryName_p);
                }
            }
            catch (CoreException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("FactoryComponentGeneratorHelper.addEntryInBinInclude(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
    }

    public static WorkspaceBuildModel getBuildModel(IProject project_p) {
        WorkspaceBuildModel buildModel = null;
        if (project_p == null) {
            return buildModel;
        }
        IFile buildFile = project_p.getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel;
    }

    public static void addStandardFactoryComponentDependencies(String pluginId_p, boolean optional_p) {
        String[] dependencies = FactoryComponentGeneratorHelper.getStandardDependencies();
        IPluginChangesCommand commandsOnManifest = ManifestChangeCommandFactory.setRequiredPlugins(dependencies, optional_p);
        EgfPdeActivator.getDefault().getPluginChangesCommandRunner().performChangesOnManifest(pluginId_p, Collections.singletonList(commandsOnManifest));
    }

    public static String[] getStandardDependencies() {
        String[] dependencies = new String[]{CoreActivator.getDefault().getPluginID(), "org.eclipse.egf.pattern"};
        return dependencies;
    }
}

